% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_codeIds_from_qna_codings.R
\name{get_codeIds_from_qna_codings}
\alias{get_codeIds_from_qna_codings}
\title{Get the code identifiers from QNA codings}
\usage{
get_codeIds_from_qna_codings(
  x,
  within = "network",
  return = "all",
  includeUIDs = TRUE
)
}
\arguments{
\item{x}{A parsed source or multiple parsed sources}

\item{within}{Which type of network coding to look in}

\item{return}{What to return ('all', 'nodes', 'edges', 'from', 'to')}

\item{includeUIDs}{Whether to return the UIDs as well}
}
\value{
A character vector or data frame
}
\description{
Get the code identifiers from QNA codings
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Read a souce coded with the Qualitative Network Approach
qnaExample <-
  rock::parse_source(
    file.path(
      examplePath,
      "network-example-1.rock"
    )
  );

rock::get_codeIds_from_qna_codings(
  qnaExample
);
}
