test_that("each export has documentation (alias present)", {
  skip()
  skip_if_not(requireNamespace("robustfa", quietly = TRUE))
  ex <- getNamespaceExports("robustfa")
  db <- tryCatch(
    tools::Rd_db("robustfa"),
    error = function(e) testthat::skip(paste("docs unavailable/corrupt:", conditionMessage(e)))
  )
  aliases <- unique(unlist(lapply(db, function(rd) tools:::.Rd_get_metadata(rd, "alias"))))
  missing <- setdiff(ex, aliases)
  if (length(missing)) message("Undocumented exports: ", paste(missing, collapse = ", "))
  expect_lt(length(missing), max(1, floor(length(ex) * 0.25)))
})
