% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{simes}
\alias{simes}
\title{Simes (1986) procedure for multiple testing}
\usage{
simes(pvals, alpha)
}
\arguments{
\item{pvals}{A numeric vector of p-values corresponding to the p-values of
the individual null hypotheses.}

\item{alpha}{A numeric value representing the global significance level.}
}
\value{
\code{simes()} returns a list with three named elements.
\code{$reject} stores a logical value whether the global null hypothesis has
been rejected. \code{$alpha} stores the significance level that was chosen.
\code{$details} stores a matrix of the individual null hypothesis p-values,
the adjusted significance level according to Simes' procedure, and the
rejection decision for each individual hypothesis test.
}
\description{
\code{simes()} takes a vector of p-values corresponding to individual null
hypotheses and performs the Simes (1986) procedure for the global null
hypothesis. The global null hypothesis is the intersection of all individual
null hypotheses.
}
\details{
See Simes (1986), \doi{doi:10.1093/biomet/73.3.751}.
}
\keyword{internal}
