% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robGR.r, R/robGR_bak.r
\name{robGR}
\alias{robGR}
\title{Robust estimator for a generalized ratio model}
\usage{
robGR(x1, y1, g1 = 0, c1 = 8, rp.max = 100, cg.rt = 0.001)

robGR(x1, y1, g1 = 0, c1 = 8, rp.max = 100, cg.rt = 0.001)
}
\arguments{
\item{x1}{single explanatory variable (a vector)}

\item{y1}{objective variable to be imputed (a vector)}

\item{g1}{initial gamma value (default g1=0.5)}

\item{c1}{tuning constant for Tukey's biweight function. Supposed to choose 4 to 8.
Smaller figure is more robust (default tp=8).}

\item{rp.max}{maximum number of iteration (default: rp.max=50)}

\item{cg.rt}{convergence condition to stop iteration (default: cg.rt=0.001)}
}
\value{
a list with the following elements
\describe{
\item{\code{par}}{robustly estimated ratio of y1 to x1 (beta)}
\item{\code{g1}}{robustly estimated power (gamma)}
\item{\code{res}}{homoscedastic quasi-residuals}
\item{\code{wt}}{robust weights}
\item{\code{rp}}{total number of iteration}
\item{\code{efg}}{error flag. 1: calculation not coverged,  0: successful termination}
\item{\code{rt.cg}}{change of par(beta)}
\item{\code{g1.cg}}{changes of g1(gamma)}
\item{\code{s1.cg}}{changes of the scale(AAD)}
}

a list with the following elements
\describe{
\item{\code{par}}{robustly estimated ratio of y1 to x1 (beta)}
\item{\code{g1}}{robustly estimated power (gamma)}
\item{\code{res}}{homoscedastic quasi-residuals}
\item{\code{wt}}{robust weights}
\item{\code{rp}}{total number of iteration}
\item{\code{efg}}{error flag. 1: calculation not coverged,  0: successful termination}
\item{\code{rt.cg}}{change of par(beta)}
\item{\code{g1.cg}}{changes of g1(gamma)}
\item{\code{s1.cg}}{changes of the scale(AAD)}
}
}
\description{
This function simultaneously estimates two parameters of
the generalized ratio model \url{doi:10.17713/ajs.v50i1.994}.
It uses Tukey's biweight function and AAD for scale of quasi residuals.

This robGR function simultaneously estimate two parameters of
the generalized ratio model. It uses Tukey's biweight function and AAD for
scale of quasi residuals.
}
