% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hirls.r
\name{Hirls.aad}
\alias{Hirls.aad}
\title{Robust estimator for the linear regression model
with Huber's weight function and AAD scal
by iteratively re-weighted least squares (IRLS) algorithm}
\usage{
Hirls.aad(
  x1,
  y1,
  rt = rep(1, length(y1)),
  c1 = 1.15,
  rp.max = 150,
  cg.rt = 0.01
)
}
\arguments{
\item{x1}{explanatory variable(s)}

\item{y1}{objective variable}

\item{rt}{sample weights}

\item{c1}{tuning parameter from 1.15 to 2.30 for the scale parameter of AAD(Average Absolute Deviation)}

\item{rp.max}{maximum number of iteration}

\item{cg.rt}{convergence condition to stop iteration (default: cg1=0.001)}
}
\value{
a list with the following elements
\describe{
\item{\code{HB}}{results of robust regression}
\item{\code{wt}}{robust weights}
\item{\code{rp}}{total number of iteration}
\item{\code{s1}}{changes in scale through iterative calculation}
}
}
\description{
Robust estimator for the linear regression model
with Huber's weight function and AAD scal
by iteratively re-weighted least squares (IRLS) algorithm
}
