% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZBsplineBasis.R
\name{ZBsplineBasis}
\alias{ZBsplineBasis}
\title{ZB-spline basis}
\usage{
ZBsplineBasis(t, knots, order, basis.plot = FALSE)
}
\arguments{
\item{t}{a vector of argument values at which the ZB-spline basis functions are to be evaluated}

\item{knots}{sequence of knots}

\item{order}{order of the ZB-splines (i.e., degree + 1)}

\item{basis.plot}{if TRUE, the ZB-spline basis system is plotted}
}
\value{
\item{\code{ZBsplineBasis}}{matrix of ZB-spline basis functions evaluated at a vector of argument values t}
\item{\code{nbasis}}{number of ZB-spline basis functions}
}
\description{
Spline basis system having zero-integral on I=[a,b] of the L^2_0 space (called ZB-splines) has been
proposed for an basis representation of fcenLR transformed probability density functions. The ZB-spline basis functions can be back
transformed to Bayes spaces using inverse of fcenLR transformation, resulting in compositional B-splines (CB-splines), 
and forming a basis system of the Bayes spaces.
}
\examples{
# Example: ZB-spline basis functions evaluated at a vector of argument values t
t = seq(0,20,l=500)
knots = c(0,2,5,9,14,20)
order = 4

ZBsplineBasis.out = ZBsplineBasis(t,knots,order, basis.plot=TRUE)

# Back-transformation of ZB-spline basis functions from L^2_0 to Bayes space -> 
# CB-spline basis functions
CBsplineBasis=NULL
for (i in 1:ZBsplineBasis.out$nbasis)
{
 CB_spline = fcenLRinv(t,diff(t)[1:2],ZBsplineBasis.out$ZBsplineBasis[,i])
 CBsplineBasis = cbind(CBsplineBasis,CB_spline)
}

matplot(t,CBsplineBasis, type="l",lty=1, las=1, 
  col=rainbow(ZBsplineBasis.out$nbasis), xlab="t", 
  ylab="CB-spline basis",
cex.lab=1.2,cex.axis=1.2)
abline(v=knots, col="gray", lty=2)
}
\references{
Machalova, J., Talska, R., Hron, K. Gaba, A. Compositional splines 
for representation of density functions. \emph{Comput Stat} (2020). 
https://doi.org/10.1007/s00180-020-01042-7
}
\author{
J. Machalova \email{jitka.machalova@upol.cz}, R. Talska \email{talskarenata@seznam.cz}
}
