% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fossils.R
\name{get_fossils}
\alias{get_fossils}
\title{Retrieve collections from the Paleobiology Database}
\usage{
get_fossils(
  unit_id = NULL,
  column_id = NULL,
  interval_name = NULL,
  age = NULL,
  age_top = NULL,
  age_bottom = NULL,
  lithology = NULL,
  lithology_id = NULL,
  lithology_type = NULL,
  lithology_class = NULL,
  environ = NULL,
  environ_id = NULL,
  environ_type = NULL,
  environ_class = NULL,
  econ = NULL,
  econ_id = NULL,
  econ_type = NULL,
  econ_class = NULL,
  project_id = NULL,
  strat_name_id = NULL,
  sf = FALSE
)
}
\arguments{
\item{unit_id}{\code{integer}. Filter PBDB collections to those within one or
more unit(s) as specified by their unique identification number(s).}

\item{column_id}{\code{integer}. Filter PBDB collections to those within one
or more column(s) as specified by their unique identification number(s).}

\item{interval_name}{\code{character}. Filter PBDB collections to those that
overlap with a named chronostratigraphic time interval (e.g., "Permian").}

\item{age}{\code{numeric}. Filter PBDB collections to those that overlap with
the specified numerical age, in millions of years before present.}

\item{age_top}{\code{numeric}. Filter PBDB collections to those that overlap
with the age range between the specified numerical age and \code{age_bottom}.
Should be in millions of years before present. \code{age_bottom} must also be
specified, and this must be older than \code{age_top}.}

\item{age_bottom}{\code{numeric}. Filter PBDB collections to those that
overlap with the age range between the specified numerical age and
\code{age_top}. Should be in millions of years before present. \code{age_top} must
also be specified, and this must be younger than \code{age_bottom}.}

\item{lithology}{\code{character}. Filter PBDB collections to those
containing a named lithology (e.g., "shale", "sandstone").}

\item{lithology_id}{\code{integer}. Filter PBDB collections to those
containing one or more lithology(ies) identified by their unique
identification number(s).}

\item{lithology_type}{\code{character}. Filter PBDB collections to those
containing a named lithology type (e.g., "carbonate", "siliciclastic").}

\item{lithology_class}{\code{character}. Filter PBDB collections to those
containing a named lithology class (e.g., "sedimentary", "igneous",
"metamorphic").}

\item{environ}{\code{character}. Filter PBDB collections to those containing
a named environment (e.g., "delta plain", "pond").}

\item{environ_id}{\code{integer}. Filter PBDB collections to those containing
one or more environment(s) as specified by their unique identification
number(s).}

\item{environ_type}{\code{character}. Filter PBDB collections to those
containing a named environment type (e.g., "fluvial", "eolian", "glacial").}

\item{environ_class}{\code{character}. Filter PBDB collections to those
containing a named environment class (e.g., "marine", "non-marine").}

\item{econ}{\code{character}. Filter PBDB collections to those containing a
named economic attribute (e.g., "brick", "ground water", "gold").}

\item{econ_id}{\code{integer}. Filter PBDB collections to those containing
one or more economic attribute(s) as specified by their unique
identification number(s).}

\item{econ_type}{\code{character}. Filter PBDB collections to those
containing a named economic attribute type (e.g., "construction",
"aquifer", "mineral").}

\item{econ_class}{\code{character}. Filter PBDB collections to those
containing a named economic attribute class (e.g., "material", "water",
"precious commodity").}

\item{project_id}{\code{integer}. Filter sections to those contained within a
Macrostrat project as specified by its unique identification number.}

\item{strat_name_id}{\code{integer}. Filter PBDB collections to those
containing a unit that matches one or more stratigraphic name(s) as
specified by their unique identification number(s).}

\item{sf}{\code{logical}. Should the results be returned as an \code{sf} object?
Defaults to \code{FALSE}.}
}
\value{
A \code{dataframe} containing the following columns:
\itemize{
\item \code{collection_no}: The unique identification number of the
collection, as assigned in the PBDB.
\item \code{collection_name}: The unique name of the collection, as
assigned in the PBDB.
\item \code{t_age}: The top age of the unit containing the collection,
estimated using the continuous time age model, in millions of years before
present.
\item \code{b_age}: The bottom age of the unit containing the collection,
estimated using the continuous time age model, in millions of years before
present.
\item \code{pbdb_occs}: The count of PBDB occurrences in the specified
PBDB collection.
\item \code{genus_no}: A vector containing the unique identification number
for each genus that appears in the collection, corresponding to the
genus_no column in the Paleobiology Database.
\item \code{taxon_no}: The count of unique taxa in the specified PBDB
collection.
\item \code{unit_id}: The unique identification number of the Macrostrat
unit containing the specified PBDB collection.
\item \code{col_id}: The unique identification number of the Macrostrat
column containing the specified PBDB collection.
\item \code{refs}: Reference for the source of the data.
\item \code{strat_name_concept_id}: The unique identification number of the
stratigraphic name concept containing the specified PBDB collection.
}
If \code{sf = TRUE}, an \code{sf} object is returned instead.
}
\description{
A function to retrieve collections from the \href{https://paleobiodb.org/#/}{Paleobiology Database} (PBDB), matched to Macrostrat units.
}
\details{
More information can be found for the inputs for this function
using the definition functions (beginning with \code{def_}). Terminology
related to the PBDB can be found at \url{https://paleobiodb.org/#/} or in
the suggested references below.
}
\section{Developer(s)}{

Christopher D. Dean
}

\section{Reviewer(s)}{

Lewis A. Jones
}

\section{References}{

Peters, S.E. and McClennen, M. (2016). The Paleobiology Database
application programming interface. \emph{Paleobiology}, 42(1), pp. 1--7.
\doi{10.1017/pab.2015.39}.

Uhen, M.D., Allen, B., Behboudi, N., Clapham, M.E., Dunne, E., Hendy, A.,
Holroyd, P.A., Hopkins, M., Mannion, P., Novack-Gottshall, P. and Pimiento,
C. (2023). Paleobiology Database User Guide Version 1.0. \emph{PaleoBios},
40(11), pp. 1--56. \doi{10.5070/P9401160531}.
}

\examples{
\donttest{
 # Get fossils by Macrostrat column ID
 ex1 <- get_fossils(column_id = 10)
 # Get fossils by Macrostrat unit ID
 ex2 <- get_fossils(unit_id = 6279)
 # Get fossils by lithology and age
 ex3 <- get_fossils(lithology = "sandstone", age_top = 66, age_bottom = 73)
 # Get fossils by environment type and age
 ex4 <- get_fossils(environ_type = "fluvial", age =  253)
}
}
\seealso{
External data:
\code{\link{def_drilling_sites}()},
\code{\link{def_measurements}()},
\code{\link{get_eodp}()},
\code{\link{get_measurements}()}
}
\concept{external}
