% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilstep.r
\name{wilstep}
\alias{wilstep}
\title{Wilcoxon One Step Rank-based Estimate in GR Method}
\usage{
wilstep(I, sec, mat, init = F, y, x, sigmaa2 = 1, sigmaw2 = 1,
  sigmae2 = 1, thetaold = c(0), eps = 1e-04, iflag2 = 0,
  rprpair = "hl-disp")
}
\arguments{
\item{I}{Number of clusters.}

\item{sec}{A vector of subcluster numbers in clusters.}

\item{mat}{A matrix of numbers of observations in subclusters.  Dimension is
Ixmax(number ofsubclusters). Each row indicates one cluster.}

\item{init}{boolean}

\item{y}{Response vector of nx1.}

\item{x}{Design matrix, pxn, without intercept.}

\item{sigmaa2}{Initial sigma for cluster in three-level design.}

\item{sigmaw2}{Initial sigma for subcluster in three-level design.}

\item{sigmae2}{Initial sigma for error in three-level design.}

\item{thetaold}{Initial input.}

\item{eps}{Epsilon value}

\item{iflag2}{y or n}

\item{rprpair}{Either 'hl-disp' or 'med-mad'}
}
\description{
Gets weighted rank based fittings for nested designs.
}
\details{
Initial inputs are from the independent model.
}
\references{
Y. K. Bilgic and J. W. McKean. Iteratively reweighted
generalized rank-based method in mixed models. 2013. Under preperation.

J. T. Terpstra and J. W. McKean. Rank-based analysis of linear models using
R. Journal of Statistical Software, 14(7) 1 - 26, 7 2005. ISSN 1548-7660.
URL http://www.jstatsoft.org/v14/i07.
}
\author{
J. W. McKean and Y. K. Bilgic
}
