% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings.R
\name{as_listing}
\alias{as_listing}
\alias{spanning_col_label_df}
\alias{spanning_col_label_df<-}
\alias{as_keycol}
\alias{is_keycol}
\alias{get_keycols}
\alias{listing_dispcols}
\alias{add_listing_dispcol}
\alias{listing_dispcols<-}
\alias{align_colnames}
\alias{align_colnames<-}
\alias{add_listing_col}
\title{Create a listing from a \code{data.frame} or \code{tibble}}
\usage{
as_listing(
  df,
  key_cols = names(df)[1],
  disp_cols = NULL,
  non_disp_cols = NULL,
  sort_cols = key_cols,
  unique_rows = FALSE,
  default_formatting = list(all = fmt_config()),
  col_formatting = NULL,
  align_colnames = FALSE,
  add_trailing_sep = NULL,
  trailing_sep = " ",
  main_title = NULL,
  subtitles = NULL,
  main_footer = NULL,
  prov_footer = NULL,
  split_into_pages_by_var = NULL,
  spanning_col_labels = no_spans_df,
  round_type = valid_round_type
)

spanning_col_label_df(df)

spanning_col_label_df(df) <- value

as_keycol(vec)

is_keycol(vec)

get_keycols(df)

listing_dispcols(df)

add_listing_dispcol(df, new)

listing_dispcols(df) <- value

align_colnames(df)

align_colnames(df) <- value

add_listing_col(
  df,
  name,
  fun = NULL,
  format = NULL,
  na_str = "NA",
  align = "left"
)
}
\arguments{
\item{df}{(\code{data.frame} or \code{listing_df})\cr the \code{data.frame} to be converted to a listing or
\code{listing_df} to be modified.}

\item{key_cols}{(\code{character})\cr vector of names of columns which should be treated as \emph{key columns}
when rendering the listing. Key columns allow you to group repeat occurrences.}

\item{disp_cols}{(\code{character} or \code{NULL})\cr vector of names of non-key columns which should be
displayed when the listing is rendered. Defaults to all columns of \code{df} not named in \code{key_cols} or
\code{non_disp_cols}.}

\item{non_disp_cols}{(\code{character} or \code{NULL})\cr vector of names of non-key columns to be excluded as display
columns. All other non-key columns are treated as display columns. Ignored if \code{disp_cols} is non-\code{NULL}.}

\item{sort_cols}{(\code{character} or \code{NULL})\cr vector of names of columns (in order) which should be used to sort the
listing. Defaults to \code{key_cols}. If \code{NULL}, no sorting will be performed.}

\item{unique_rows}{(\code{flag})\cr whether only unique rows should be included in the listing. Defaults to \code{FALSE}.}

\item{default_formatting}{(\code{list})\cr a named list of default column format configurations to apply when rendering
the listing. Each name-value pair consists of a name corresponding to a data class (or "numeric" for all
unspecified numeric classes) and a value of type \code{fmt_config} with the format configuration that should be
implemented for columns of that class. If named element "all" is included in the list, this configuration will be
used for all data classes not specified. Objects of type \code{fmt_config} can take 3 arguments: \code{format}, \code{na_str},
and \code{align}.}

\item{col_formatting}{(\code{list})\cr a named list of custom column formatting configurations to apply to specific
columns when rendering the listing. Each name-value pair consists of a name corresponding to a column name and a
value of type \code{fmt_config} with the formatting configuration that should be implemented for that column. Objects
of type \code{fmt_config} can take 3 arguments: \code{format}, \code{na_str}, and \code{align}. Defaults to \code{NULL}.}

\item{align_colnames}{(\code{flag})\cr whether the column titles should have the same alignment as their columns. All
titles default to \code{"center"} alignment if \code{FALSE} (default). This can be changed with \code{align_colnames()}.}

\item{add_trailing_sep}{(\code{character} or \code{numeric} or \code{NULL})\cr If it is assigned to one or more column names,
a trailing separator will be added between groups with identical values for that column. Numeric option allows
the user to specify in which rows it can be added. Defaults to \code{NULL}.}

\item{trailing_sep}{(\code{character(1)})\cr The separator to be added between groups. The character will be repeated to
fill the row.}

\item{main_title}{(\code{string} or \code{NULL})\cr the main title for the listing, or \code{NULL} (the default).}

\item{subtitles}{(\code{character} or \code{NULL})\cr a vector of subtitles for the listing, or \code{NULL} (the default).}

\item{main_footer}{(\code{character} or \code{NULL})\cr a vector of main footer lines for the listing, or \code{NULL} (the default).}

\item{prov_footer}{(\code{character} or \code{NULL})\cr a vector of provenance footer lines for the listing, or \code{NULL}
(the default). Each string element is placed on a new line.}

\item{split_into_pages_by_var}{(\code{character} or \code{NULL})\cr the name of a variable for on the listing should be split
into pages, with each page corresponding to one unique value/level of the variable. See
\code{\link[=split_into_pages_by_var]{split_into_pages_by_var()}} for more details.}

\item{spanning_col_labels}{(\code{data.frame})\cr A data.frame with the columns
\code{span_level}, \code{label}, \code{start}, and \code{span} defining 0 or more levels of
addition spanning (ie grouping) of columns. Defaults to no additional spanning labels.}

\item{round_type}{(\code{string})\cr the type of rounding to perform.
Allowed values are (\code{"iec"} (default), \code{"iec_mod"} or \code{"sas"}).
\cr See \code{\link[formatters:format_value]{formatters::format_value()}} for details.}

\item{value}{(\code{string})\cr new value.}

\item{vec}{(\code{string})\cr name of a column vector from a \code{listing_df} object to be annotated as a key column.}

\item{new}{(\code{character})\cr vector of names of columns to be added to
the set of display columns.}

\item{name}{(\code{string})\cr name of the existing or new column to be
displayed when the listing is rendered.}

\item{fun}{(\code{function} or \code{NULL})\cr a function which accepts \code{df} and
returns the vector for a new column, which is added to \code{df} as
\code{name}, or \code{NULL} if marking an existing column as a listing column.}

\item{format}{(\code{string} or \code{function})\cr a format label (string) or formatter function.}

\item{na_str}{(\code{string})\cr string that should be displayed in place of missing values.}

\item{align}{(\code{string})\cr alignment values should be rendered with.}
}
\value{
A \code{listing_df} object, sorted by its key columns.

\code{df} with \code{name} created (if necessary) and marked for
display during rendering.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Create listings displaying \code{key_cols} and \code{disp_cols} to produce a compact and
elegant representation of the input \code{data.frame} or \code{tibble}.
}
\details{
At its core, a \code{listing_df} object is a \code{tbl_df} object with a customized
print method  and support for the formatting and pagination machinery provided by
the \code{formatters} package.

\code{listing_df} objects have two 'special' types of columns: key columns and display columns.

Key columns act as indexes, which means a number of things in practice.

All key columns are also display columns.

\code{listing_df} objects are always sorted by their set of key columns at creation time.
Any \code{listing_df} object which is not sorted by its full set of key columns (e.g.,
one whose rows have been reordered explicitly during creation) is invalid and the behavior
when rendering or paginating that object is undefined.

Each value of a key column is printed only once per page and per unique combination of
values for all higher-priority (i.e., to the left of it) key columns. Locations
where a repeated value would have been printed within a key column for the same
higher-priority-key combination on the same page are rendered as empty space.
Note, determination of which elements to display within a key column at rendering is
based on the underlying value; any non-default formatting applied to the column
has no effect on this behavior.

Display columns are columns which should be rendered, but are not key columns. By
default this is all non-key columns in the incoming data, but in need not be.
Columns in the underlying data which are neither key nor display columns remain
within the object available for computations but \emph{are not rendered during
printing or export of the listing}.

Spanning column labels are displayed centered above the individual labels
of the columns they span across. \code{span_level} 1 is placed directly above
the column labels, with higher "span_levels` displayed above it in ascending
order.

IF spanning column labels are present, a single spanning label cannot span
across both key and non-key displayed columns simultaneously due to key
columns' repetition after page breaks during horizontal pagination. Attempting
to set a spanning column label which does so will result in an error.
}
\note{
Unlike in the \code{rtables} sister package, spanning labels here are purely
decorative and do not reflect any structure among the columns modeled by
\code{rlistings}. Thus, we cannot, e.g., use pathing to select columns under
a certain spanning column label, or restrict horizontal pagination to
leave 'groups' of columns implied by a spanning label intact.
}
\examples{
dat <- ex_adae

# This example demonstrates the listing with key_cols (values are grouped by USUBJID) and
# multiple lines in prov_footer
lsting <- as_listing(dat[1:25, ],
  key_cols = c("USUBJID", "AESOC"),
  main_title = "Example Title for Listing",
  subtitles = "This is the subtitle for this Adverse Events Table",
  main_footer = "Main footer for the listing",
  prov_footer = c(
    "You can even add a subfooter", "Second element is place on a new line",
    "Third string"
  )
) \%>\%
  add_listing_col("AETOXGR") \%>\%
  add_listing_col("BMRKR1", format = "xx.x") \%>\%
  add_listing_col("AESER / AREL", fun = function(df) paste(df$AESER, df$AREL, sep = " / "))

mat <- matrix_form(lsting)

cat(toString(mat))

# This example demonstrates the listing table without key_cols
# and specifying the cols with disp_cols.
dat <- ex_adae
lsting <- as_listing(dat[1:25, ],
  disp_cols = c("USUBJID", "AESOC", "RACE", "AETOXGR", "BMRKR1")
)

mat <- matrix_form(lsting)

cat(toString(mat))

# This example demonstrates a listing with format configurations specified
# via the default_formatting and col_formatting arguments
dat <- ex_adae
dat$AENDY[3:6] <- NA
lsting <- as_listing(dat[1:25, ],
  key_cols = c("USUBJID", "AESOC"),
  disp_cols = c("STUDYID", "SEX", "ASEQ", "RANDDT", "ASTDY", "AENDY"),
  default_formatting = list(
    all = fmt_config(align = "left"),
    numeric = fmt_config(
      format = "xx.xx",
      na_str = "<No data>",
      align = "right"
    )
  )
) \%>\%
  add_listing_col("BMRKR1", format = "xx.x", align = "center")

mat <- matrix_form(lsting)

cat(toString(mat))

}
