% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkStatus.R
\name{checkStatus}
\alias{checkStatus}
\title{Check the status of an existing LANDFIRE Product Service (LFPS) request}
\usage{
checkStatus(landfire_api, verbose = TRUE, method = "curl")
}
\arguments{
\item{landfire_api}{\code{landfire_api} object returned from \code{landfireAPIv2()}}

\item{verbose}{If FALSE suppress all status messages}

\item{method}{Passed to \code{\link[utils:download.file]{utils::download.file()}}. See \code{?download.file} or
use "none" to skip download and use \code{landfire_vsi()}}
}
\value{
Returns a \code{landfire_api} object with named elements:
\itemize{
\item \code{request} - list with elements \code{query}, \code{date}, \code{url}, \code{job_id}, \code{request},\code{dwl_url}
\item \code{content} - Informative messages passed from API
\item \code{response} - Full response
\item \code{status} - Final API status, one of "Failed", "Succeeded", or "Timed out"
\item \code{time} - time of job completion
\item \code{path} - path to save directory
}
}
\description{
\code{checkStatus} checks if a previous request is complete and downloads available data
}
\examples{
\dontrun{
products <-  c("ASP2020", "ELEV2020", "230CC")
aoi <- c("-123.7835", "41.7534", "-123.6352", "41.8042")
email <- "email@example.com"
resp <- landfireAPIv2(products, aoi, email, background = TRUE)
checkStatus(resp)
}
}
