% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R, R/submit-rjournal.R
\name{initial_check_article}
\alias{initial_check_article}
\alias{check_filenames}
\alias{check_structure}
\alias{check_folder_structure}
\alias{check_unnecessary_files}
\alias{check_cover_letter}
\alias{check_title}
\alias{check_section}
\alias{check_abstract}
\alias{check_spelling}
\alias{check_proposed_pkg}
\alias{check_pkg_label}
\alias{check_packages_available}
\alias{check_bib_doi}
\alias{check_csl}
\alias{check_date}
\alias{get_orcid}
\title{A single article check}
\usage{
initial_check_article(
  path,
  dic = "en_US",
  pkg,
  ...,
  ask = interactive(),
  logfile = file.path(path, "initial_checks.log")
)

check_filenames(path)

check_structure(path)

check_folder_structure(path)

check_unnecessary_files(path)

check_cover_letter(path)

check_title(path, ignore = "")

check_section(path)

check_abstract(path)

check_spelling(path, dic = "en_US", ...)

check_proposed_pkg(pkg, ask = interactive())

check_pkg_label(path)

check_packages_available(path, ignore)

check_bib_doi(path)

check_csl(path)

check_date(path, file)

get_orcid(path, file = NULL)
}
\arguments{
\item{path}{string, path to the directory that contains the .tex
file (Ideally, this directory should contain .bib, .Rmd, and
.tex with author names and two RJwrapper files:  RJwrapper.pdf
and RJwrapper.tex)}

\item{dic}{string, the dictionary used for spelling check. See
\code{dict} argument in [hunspell::hunspell()]}

\item{pkg}{string, optional. The name of the proposed package (if
relevant), to be checked for activity on CRAN}

\item{...}{additional arguments for spelling check with
[hunspell::hunspell]}

\item{ask}{logical, if \code{TRUE} then checks may ask the user for
interactive input of missing information.}

\item{logfile}{a connection for the output log, or a string with
the filename of the output log or \code{NULL} if no log should
be written}

\item{ignore}{The words to ignore in title check, use c(pkg, pkg, ...) for multiple quoted words}

\item{file}{string, the file name if multiple files are detected
under the \code{path} argument}
}
\value{
list of all results (see \code{log_error} for
    details). You can use \code{unlist()} to get a character vector
    of the result statuses.
}
\description{
A single article check
}
\details{
Folder structure checks:

* \code{check_filenames()}: the three files (.bib, .Rmd, and .tex) all present and have consistent names
* \code{check_structure()}: check validity of all filenames and depth of the directory structure
* \code{check_unnecessary_files()}: the template file (i.e., RJtemplate.tex) is not included in the directory
* \code{check_cover_letter()}: a motivational letter

Content checks:

* \code{check_title()}: article title is in title case
* \code{check_section()}: section sections are in sentence case
* \code{check_abstract()}: abstract should be plain text without package
markups (CRANpkg, BIOpkg, pkg), math notations($...$), citations, and other
formattings (highlight, italic, etc)
* \code{check_spelling()}: potential spelling mistakes
* \code{check_proposed_pkg()}: package proposed in the paper is on CRAN
* \code{check_pkg_label()}: packages marked up with \samp{\pkg{}} are not available
on CRAN or BioConductor
* \code{check_packages_available()}: packages mentioned in the article are
available on CRAN
* \code{check_bib_doi}: whether bib entries have DOI or URL included, uncless
can't sourced online
* \code{check_csl}: no additional csl file should be used
consistent, either in sentence (preferred) or title case

See \code{vignette("create_article", package = "rjtools")} for how to use the check functions
}
\examples{
your_article_path <- system.file("sample-article", package = "rjtools")
if (interactive()) initial_check_article(your_article_path)

}
