% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{arima_sum}
\alias{arima_sum}
\title{Sum ARIMA Models}
\usage{
arima_sum(...)
}
\arguments{
\item{...}{list of ARIMA models (created with \code{\link[=arima_model]{arima_model()}}).}
}
\value{
a \code{"JD3_ARIMA"} model.
}
\description{
Sum ARIMA Models
}
\details{
Adds several Arima models, considering that their innovations are independent.
The sum of two Arima models is computed as follows:
the auto-regressive parts (stationary and non stationary of the aggregated
model are the smaller common multiple of the corresponding polynomials of
the components. The sum of the acf of the modified moving average
polynomials is then computed and factorized, to get the moving average
polynomial and innovation variance of the sum.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
mod1 <- arima_model(ar = c(0.1, 0.2), delta = 0, ma = 0)
mod2 <- arima_model(ar = 0, delta = 0, ma = c(0.4))
arima_sum(mod1, mod2)
\dontshow{\}) # examplesIf}
}
