/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

public final class LapackUtility {
    public static void dger(FastMatrix A, double alpha, DataBlock x, DataBlock y) {
        if (A.isEmpty() || alpha == 0.0) {
            return;
        }
        DataBlockIterator columns = A.columnsIterator();
        DoubleSeqCursor.OnMutable cursor = y.cursor();
        while (columns.hasNext()) {
            double tmp = cursor.getAndNext();
            DataBlock col = columns.next();
            if (tmp == 0.0) continue;
            col.addAY(tmp * alpha, x);
        }
    }

    public static double dasum(int n, double[] dx, int startx, int incx) {
        double rslt = 0.0;
        if (n <= 0 || incx < 0) {
            return 0.0;
        }
        if (incx == 1) {
            int imax = startx + n;
            for (int i = startx; i < imax; ++i) {
                rslt += Math.abs(dx[i]);
            }
        } else {
            int i1 = startx + n * incx;
            for (int i = startx; i < i1; i += incx) {
                rslt += Math.abs(dx[i]);
            }
        }
        return rslt;
    }

    public static double asum(DoubleSeq x) {
        int n = x.length();
        if (n <= 0) {
            return 0.0;
        }
        double rslt = 0.0;
        DoubleSeqCursor cursor = x.cursor();
        for (int i = 0; i < n; ++i) {
            rslt += Math.abs(cursor.getAndNext());
        }
        return rslt;
    }

    public static double nrm2(int n, double[] dx, int startx, int incx) {
        if (n < 1) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(dx[startx]);
        }
        int imax = startx + n * incx;
        double scale = 0.0;
        double ssq = 1.0;
        for (int i = startx; i != imax; i += incx) {
            double tmp;
            double xcur = dx[i];
            if (xcur == 0.0) continue;
            double absxi = Math.abs(xcur);
            if (scale < absxi) {
                tmp = scale / absxi;
                ssq = 1.0 + ssq * tmp * tmp;
                scale = absxi;
                continue;
            }
            tmp = absxi / scale;
            ssq += tmp * tmp;
        }
        return scale * Math.sqrt(ssq);
    }

    public static double nrm2(DoubleSeq seq) {
        int n = seq.length();
        if (n < 1) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(seq.get(0));
        }
        DoubleSeqCursor cursor = seq.cursor();
        double scale = 0.0;
        double ssq = 1.0;
        for (int i = 0; i < n; ++i) {
            double tmp;
            double xcur = cursor.getAndNext();
            if (xcur == 0.0) continue;
            double absxi = Math.abs(xcur);
            if (scale < absxi) {
                tmp = scale / absxi;
                ssq = 1.0 + ssq * tmp * tmp;
                scale = absxi;
                continue;
            }
            tmp = absxi / scale;
            ssq += tmp * tmp;
        }
        return scale * Math.sqrt(ssq);
    }

    public static double lapy2(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        double xabs = Math.abs(x);
        double yabs = Math.abs(y);
        double w = Math.max(xabs, yabs);
        double z = Math.min(xabs, yabs);
        if (z == 0.0) {
            return w;
        }
        return w * Math.sqrt(1.0 + (z /= w) * z);
    }

    public static void dger(FastMatrix A, double alpha, double[] px, int startx, int incx, double[] py, int starty, int incy) {
        int m = A.getRowsCount();
        int n = A.getColumnsCount();
        if (m == 0 || n == 0 || alpha == 0.0) {
            return;
        }
        int start = A.getStartPosition();
        int lda = A.getColumnIncrement();
        double[] pa = A.getStorage();
        if (incx == 1) {
            int j = 0;
            int jc = start;
            int iy = starty;
            while (j < n) {
                double ycur = py[iy];
                if (ycur != 0.0) {
                    double tmp = alpha * ycur;
                    int imax = jc + m;
                    int ic = jc;
                    int ix = startx;
                    while (ic < imax) {
                        int n2 = ic++;
                        pa[n2] = pa[n2] + px[ix] * tmp;
                        ++ix;
                    }
                }
                ++j;
                jc += lda;
                iy += incy;
            }
        } else {
            int j = 0;
            int jc = start;
            int iy = starty;
            while (j < n) {
                double ycur = py[iy];
                if (ycur != 0.0) {
                    double tmp = alpha * ycur;
                    int imax = jc + m;
                    int ic = jc;
                    int ix = startx;
                    while (ic < imax) {
                        int n3 = ic++;
                        pa[n3] = pa[n3] + px[ix] * tmp;
                        ix += incx;
                    }
                }
                ++j;
                jc += lda;
                iy += incy;
            }
        }
    }

    public static void ger(FastMatrix A, double alpha, DataBlock x, DataBlock y) {
        if (alpha == 0.0 || A.isEmpty()) {
            return;
        }
        DataBlockIterator cols = A.columnsIterator();
        DoubleSeqCursor.OnMutable cursor = y.cursor();
        while (cols.hasNext()) {
            double ycur = cursor.getAndNext();
            DataBlock c = cols.next();
            if (ycur == 0.0) continue;
            c.addAY(ycur, x);
        }
    }

    public static void axpy(double a, DoubleSeq X, DataBlock y) {
        int n = y.length();
        if (n == 0 || a == 0.0) {
            return;
        }
        DoubleSeqCursor xcur = X.cursor();
        double[] py = y.getStorage();
        int inc = y.getIncrement();
        int end = y.getEndPosition();
        if (inc == 1) {
            if (a == 1.0) {
                while (start != end) {
                    int n2 = start++;
                    py[n2] = py[n2] + xcur.getAndNext();
                }
            } else if (a == -1.0) {
                while (start < end) {
                    py[start++] = xcur.getAndNext();
                }
            } else {
                while (start < end) {
                    int n3 = start++;
                    py[n3] = py[n3] + a * xcur.getAndNext();
                }
            }
        } else if (a == 1.0) {
            for (start = y.getStartPosition(); start != end; start += inc) {
                int n4 = start;
                py[n4] = py[n4] + xcur.getAndNext();
            }
        } else if (a == -1.0) {
            while (start != end) {
                py[start] = xcur.getAndNext();
                start += inc;
            }
        } else {
            while (start != end) {
                int n5 = start;
                py[n5] = py[n5] + a * xcur.getAndNext();
                start += inc;
            }
        }
    }

    @Generated
    private LapackUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

