/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.highfreq;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.calendars.HolidaysOption;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class HolidaysSpec {
    public static HolidaysOption DEF_OPTION = HolidaysOption.Skip;
    public static final HolidaysSpec DEFAULT_UNUSED = HolidaysSpec.builder().build();
    private final String holidays;
    private final HolidaysOption holidaysOption;
    private final boolean single;
    private final int[] nonWorkingDays;
    private final boolean test;
    private final Parameter[] coefficients;

    public boolean isUsed() {
        return this.holidays != null && !this.holidays.equals("Default");
    }

    public boolean hasFixedCoefficients() {
        return Parameter.hasFixedParameters(this.coefficients);
    }

    public static Builder builder() {
        return new Builder().holidaysOption(DEF_OPTION).single(false).nonWorkingDays(HolidaysVariable.NONWORKING_WE);
    }

    @Generated
    HolidaysSpec(String holidays, HolidaysOption holidaysOption, boolean single, int[] nonWorkingDays, boolean test, Parameter[] coefficients) {
        this.holidays = holidays;
        this.holidaysOption = holidaysOption;
        this.single = single;
        this.nonWorkingDays = nonWorkingDays;
        this.test = test;
        this.coefficients = coefficients;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().holidays(this.holidays).holidaysOption(this.holidaysOption).single(this.single).nonWorkingDays(this.nonWorkingDays).test(this.test).coefficients(this.coefficients);
    }

    @Generated
    public String getHolidays() {
        return this.holidays;
    }

    @Generated
    public HolidaysOption getHolidaysOption() {
        return this.holidaysOption;
    }

    @Generated
    public boolean isSingle() {
        return this.single;
    }

    @Generated
    public int[] getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    @Generated
    public boolean isTest() {
        return this.test;
    }

    @Generated
    public Parameter[] getCoefficients() {
        return this.coefficients;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HolidaysSpec)) {
            return false;
        }
        HolidaysSpec other = (HolidaysSpec)o;
        if (this.isSingle() != other.isSingle()) {
            return false;
        }
        if (this.isTest() != other.isTest()) {
            return false;
        }
        String this$holidays = this.getHolidays();
        String other$holidays = other.getHolidays();
        if (this$holidays == null ? other$holidays != null : !this$holidays.equals(other$holidays)) {
            return false;
        }
        HolidaysOption this$holidaysOption = this.getHolidaysOption();
        HolidaysOption other$holidaysOption = other.getHolidaysOption();
        if (this$holidaysOption == null ? other$holidaysOption != null : !((Object)((Object)this$holidaysOption)).equals((Object)other$holidaysOption)) {
            return false;
        }
        if (!Arrays.equals(this.getNonWorkingDays(), other.getNonWorkingDays())) {
            return false;
        }
        return Arrays.deepEquals(this.getCoefficients(), other.getCoefficients());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingle() ? 79 : 97);
        result = result * 59 + (this.isTest() ? 79 : 97);
        String $holidays = this.getHolidays();
        result = result * 59 + ($holidays == null ? 43 : $holidays.hashCode());
        HolidaysOption $holidaysOption = this.getHolidaysOption();
        result = result * 59 + ($holidaysOption == null ? 43 : ((Object)((Object)$holidaysOption)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getNonWorkingDays());
        result = result * 59 + Arrays.deepHashCode(this.getCoefficients());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HolidaysSpec(holidays=" + this.getHolidays() + ", holidaysOption=" + String.valueOf((Object)this.getHolidaysOption()) + ", single=" + this.isSingle() + ", nonWorkingDays=" + Arrays.toString(this.getNonWorkingDays()) + ", test=" + this.isTest() + ", coefficients=" + Arrays.deepToString(this.getCoefficients()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String holidays;
        @Generated
        private HolidaysOption holidaysOption;
        @Generated
        private boolean single;
        @Generated
        private int[] nonWorkingDays;
        @Generated
        private boolean test;
        @Generated
        private Parameter[] coefficients;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder holidays(String holidays) {
            this.holidays = holidays;
            return this;
        }

        @Generated
        public @NonNull Builder holidaysOption(HolidaysOption holidaysOption) {
            this.holidaysOption = holidaysOption;
            return this;
        }

        @Generated
        public @NonNull Builder single(boolean single) {
            this.single = single;
            return this;
        }

        @Generated
        public @NonNull Builder nonWorkingDays(int[] nonWorkingDays) {
            this.nonWorkingDays = nonWorkingDays;
            return this;
        }

        @Generated
        public @NonNull Builder test(boolean test) {
            this.test = test;
            return this;
        }

        @Generated
        public @NonNull Builder coefficients(Parameter[] coefficients) {
            this.coefficients = coefficients;
            return this;
        }

        @Generated
        public @NonNull HolidaysSpec build() {
            return new HolidaysSpec(this.holidays, this.holidaysOption, this.single, this.nonWorkingDays, this.test, this.coefficients);
        }

        @Generated
        public @NonNull String toString() {
            return "HolidaysSpec.Builder(holidays=" + this.holidays + ", holidaysOption=" + String.valueOf((Object)this.holidaysOption) + ", single=" + this.single + ", nonWorkingDays=" + Arrays.toString(this.nonWorkingDays) + ", test=" + this.test + ", coefficients=" + Arrays.deepToString(this.coefficients) + ")";
        }
    }
}

