% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bioconductor_data.R
\name{get_bioconductor_package_url}
\alias{get_bioconductor_package_url}
\title{Retrieve Bioconductor Package URL}
\usage{
get_bioconductor_package_url(
  package_name,
  package_version = NULL,
  release_data
)
}
\arguments{
\item{package_name}{A character string specifying the name of the Bioconductor package.}

\item{package_version}{(Optional) A character string specifying the package version. Defaults to `NULL`, which retrieves the latest version.}

\item{release_data}{A list containing Bioconductor release information.}
}
\value{
A list containing:
 \item{url}{The URL of the source package (if available).}
 \item{version}{The specified or latest available package version.}
 \item{last_version}{A list with version, date, and Bioconductor version.}
 \item{all_versions}{A list of all discovered versions with version, date, and Bioconductor version.}
 \item{bioconductor_version_package}{The Bioconductor version matched to the selected version.}
 \item{archived}{A logical value indicating whether the package is archived.}
}
\description{
This function fetches the source package URL for a given Bioconductor package.
If no version is specified, it retrieves the latest available version.
}
\examples{
\dontrun{
release_data <- list(
  list(release = "3.17", date = "October 14, 2005"),
  list(release = "3.18", date = "October 4, 2006"),
  list(release = "3.19", date = "October 8, 2007")
)

get_bioconductor_package_url("GenomicRanges", release_data = release_data)

}
}
