% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_config.R
\name{is_parallel_enabled}
\alias{is_parallel_enabled}
\title{Check if Parallel Processing is Enabled}
\usage{
is_parallel_enabled()
}
\value{
Logical value: \code{TRUE} if parallel processing is enabled, \code{FALSE} if sequential.
}
\description{
Checks whether parallel processing is currently enabled based on the future plan.
}
\examples{
\dontrun{
# Check current status
is_parallel_enabled()

# Enable parallel processing
set_parallel_plan("multisession")
is_parallel_enabled()  # Returns TRUE

# Disable parallel processing
set_parallel_plan("sequential")
is_parallel_enabled()  # Returns FALSE
}

}
\seealso{
\code{\link[=set_parallel_plan]{set_parallel_plan()}}, \code{\link[=should_parallelize]{should_parallelize()}}
}
