% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tangent_handler.R
\name{TangentImageHandler}
\alias{TangentImageHandler}
\title{TangentImageHandler Class}
\description{
TangentImageHandler Class

TangentImageHandler Class
}
\details{
This class handles tangent images on a manifold. It provides methods to set a reference point, compute tangents, and perform various operations using a provided metric.
Initialize the TangentImageHandler

Error if the tangent images have not been specified

Error if the reference point is not an object of class dppMatrix

Error if the matrix is not of type dspMatrix
Tangent images getter
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ref_point}}{A matrix of type dppMatrix}

\item{\code{tangent_images}}{A list of dspMatrix objects}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TangentImageHandler-new}{\code{TangentImageHandler$new()}}
\item \href{#method-TangentImageHandler-set_reference_point}{\code{TangentImageHandler$set_reference_point()}}
\item \href{#method-TangentImageHandler-compute_tangents}{\code{TangentImageHandler$compute_tangents()}}
\item \href{#method-TangentImageHandler-compute_vecs}{\code{TangentImageHandler$compute_vecs()}}
\item \href{#method-TangentImageHandler-compute_conns}{\code{TangentImageHandler$compute_conns()}}
\item \href{#method-TangentImageHandler-set_tangent_images}{\code{TangentImageHandler$set_tangent_images()}}
\item \href{#method-TangentImageHandler-add_tangent_image}{\code{TangentImageHandler$add_tangent_image()}}
\item \href{#method-TangentImageHandler-get_tangent_images}{\code{TangentImageHandler$get_tangent_images()}}
\item \href{#method-TangentImageHandler-relocate_tangents}{\code{TangentImageHandler$relocate_tangents()}}
\item \href{#method-TangentImageHandler-clone}{\code{TangentImageHandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$new(metric_obj, reference_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric_obj}}{An rmetric object for operations.}

\item{\code{reference_point}}{An optional reference point on the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of TangentImageHandler.
Set a new reference point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-set_reference_point"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-set_reference_point}{}}}
\subsection{Method \code{set_reference_point()}}{
If tangent images have been created, it recomputes them by mapping to the manifold and then to the new tangent space.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$set_reference_point(new_ref_pt, progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_ref_pt}}{A new reference point of class dppMatrix.}

\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
Computes the tangent images from the points in the manifold
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-compute_tangents"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-compute_tangents}{}}}
\subsection{Method \code{compute_tangents()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$compute_tangents(manifold_points, progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{manifold_points}}{A list of connectomes}

\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Computes vectorizations from tangent images
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-compute_vecs"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-compute_vecs}{}}}
\subsection{Method \code{compute_vecs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$compute_vecs(progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix, each row of which is a vectorization
Computes connectomes from tangent images
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-compute_conns"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-compute_conns}{}}}
\subsection{Method \code{compute_conns()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$compute_conns(progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of connectomes
Setter for the tangent images
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-set_tangent_images"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-set_tangent_images}{}}}
\subsection{Method \code{set_tangent_images()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$set_tangent_images(reference_point, tangent_images)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference_point}}{A connectome}

\item{\code{tangent_images}}{A list of tangent images}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Appends a matrix to the list of tangent images
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-add_tangent_image"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-add_tangent_image}{}}}
\subsection{Method \code{add_tangent_image()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$add_tangent_image(image)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{Matrix to be added}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-get_tangent_images"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-get_tangent_images}{}}}
\subsection{Method \code{get_tangent_images()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$get_tangent_images()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of tangent matrices
Wrapper for set_reference_point
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-relocate_tangents"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-relocate_tangents}{}}}
\subsection{Method \code{relocate_tangents()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$relocate_tangents(new_ref_pt, progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_ref_pt}}{The new reference point}

\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentImageHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TangentImageHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentImageHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
