% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing_rgm.R
\name{post_processing_rgm}
\alias{post_processing_rgm}
\title{Post-Processing for RGM (Random Graph Model)}
\usage{
post_processing_rgm(simulated_data, results)
}
\arguments{
\item{simulated_data}{A list containing simulated data from an RGM.}

\item{results}{A list containing results from fitting an RGM to `simulated_data`.}
}
\value{
A list containing ggplot objects for different diagnostics:
  - `rgm_recovery`: A plot comparing true and estimated probit values.
  - `estimation_of_alpha`: A plot comparing true and estimated alpha values.
  - `posterior_distribution`: A density plot of the posterior distribution of the beta parameter.
  - `beta_convergence`: A trace plot of the beta parameter across MCMC iterations.
  - `roc_plot`: A ROC plot for graph recovery performance.
  - `edge_prob`: A heatmap of posterior edge probabilities for each environment.
}
\description{
This function performs post-processing on simulated data and results from a Random Graph Model (RGM).
It calculates mean posterior estimates, compares true and estimated edge probabilities, generates
various diagnostic plots, and returns a list of these plots.
}
