% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permu_edge.R
\name{permu_edge}
\alias{permu_edge}
\title{get lists of permuted weighted within-sample edge-counts and between-sample edge-counts}
\usage{
permu_edge(n_per, E, n1, n2, wei, progress_bar = FALSE)
}
\arguments{
\item{n_per}{number of permutations.}

\item{E}{an edge matrix representing a similarity graph. Each row represents an edge and records the indices of two ends of an edge in two columns. The indices of observations in sample 1 are from 1 to n1 and indices of observations in sample 2 are from 1+n1 to n1+n2.}

\item{n1}{number of observations in sample 1.}

\item{n2}{number of observations in sample 2.}

\item{wei}{a vector of weights of each edge.}

\item{progress_bar}{a logical evaluating to TRUE or FALSE indicating whether a progress bar of the permutation should be printed.}
}
\value{
\item{R1}{the permuted weighted within-sample edge-counts for sample 1.}
\item{R2}{the permuted weighted within-sample edge-counts for sample 2.}
\item{R}{the permuted weighted between-sample edge-counts.}
}
\description{
get lists of permuted weighted within-sample edge-counts and between-sample edge-counts
}
\keyword{internal}
