% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsummary.R
\name{f_summary}
\alias{f_summary}
\title{Summarize a Data Frame with Grouping Variables}
\usage{
f_summary(
  data,
  data.column,
  ...,
  show_n = TRUE,
  show_mean = TRUE,
  show_sd = TRUE,
  show_se = TRUE,
  show_min = TRUE,
  show_max = TRUE,
  show_median = TRUE,
  show_Q1 = TRUE,
  show_Q3 = TRUE,
  digits = 2,
  export_to_excel = FALSE,
  close_generated_files = FALSE,
  open_generated_files = TRUE,
  save_as = NULL,
  save_in_wdir = FALSE,
  check_input = TRUE,
  eval_input = FALSE,
  digits_excel = NULL,
  detect_int_col = TRUE
)
}
\arguments{
\item{data}{A 'data.frame', 'data.table' or 'tibble', i.e. input data to be summarized.}

\item{data.column}{A character string, vector or list with characters. The name of the column(s) in \code{data} for which summary statistics will be calculated.}

\item{...}{One or more character strings specifying the grouping variables in \code{data}.}

\item{show_n}{Logical. If \code{TRUE}, the summary results \code{n} will be included in the output.}

\item{show_mean}{Logical. If \code{TRUE}, the summary results \code{mean} will be included in the output.}

\item{show_sd}{Logical. If \code{TRUE}, the summary results \code{sd} will be included in the output.}

\item{show_se}{Logical. If \code{TRUE}, the summary results \code{se} will be included in the output.}

\item{show_min}{Logical. If \code{TRUE}, the summary results \code{min} will be included in the output.}

\item{show_max}{Logical. If \code{TRUE}, the summary results \code{max} will be included in the output.}

\item{show_median}{Logical. If \code{TRUE}, the summary results \code{median} will be included in the output.}

\item{show_Q1}{Logical. If \code{TRUE}, the summary results \code{Q1} will be included in the output.}

\item{show_Q3}{Logical. If \code{TRUE}, the summary results \code{Q3} will be included in the output.}

\item{digits}{Integer. Round to the number of digits specified. If \code{digits = NULL} no rounding is applied (default is \code{digits = 2}). Note that this rounding is independent of the rounding in the exported excel file.}

\item{export_to_excel}{Logical. If \code{TRUE}, the (unrounded values) summary results will be exported to an 'Excel' file. Default is \code{FALSE}.}

\item{close_generated_files}{Logical. If \code{TRUE}, closes open 'Excel' files. This to be able to save the newly generated file. Default is \code{FALSE}.}

\item{open_generated_files}{Logical. If \code{TRUE}, Opens the generated 'Excel' files. This to directly view the results after creation. Files are stored in tempdir(). Default is \code{TRUE}.}

\item{save_as}{Character string specifying the output file path (without extension).
If a full path is provided, output is saved to that location.
If only a filename is given, the file is saved in \code{tempdir()}.
If only a directory is specified (providing an existing directory with trailing slash),
the file is named "dataname_summary.xlsx" in that directory.
Defaults to \code{file.path(tempdir(), "dataname_summary.xlsx")}.}

\item{save_in_wdir}{Logical. If \code{TRUE}, saves the file in the working directory. Default is \code{FALSE}, to avoid unintended changes to the global environment. If \code{save_as} location is specified \code{save_in_wdir} is overwritten by \code{save_as}.}

\item{check_input}{If \code{TRUE}, checks the input and stops the function if the input is incorrect (default is \code{TRUE}).}

\item{eval_input}{Logical. If \code{TRUE}, the function evaluates the third function argument. This should be a character vector with the group by columns. Default is \code{FALSE}, which allows group by columns to be written without quotes.}

\item{digits_excel}{Integer. Round cells in the excel file to the number of digits specified. If \code{digits_excel = NULL} no rounding is applied (default is \code{digits_excel = NULL}). Note to preserve formatting numbers will be stored as text.}

\item{detect_int_col}{Logical. If \code{TRUE}, columns in a data.frame containing only integers will be displayed without decimal digits. Columns containing a mix of integers and decimal values will display all values with the specified number of digits. If \code{FALSE}, each individual cell is evaluated: integer values are displayed without digits, and numbers containing digits with the specified number of digits. Default is \code{TRUE}.}
}
\value{
A data frame containing the computed summary statistics, grouped by the specified variables. This data frame can be automatically saved as an 'Excel' file using \code{export_to_excel = TRUE}.
}
\description{
Computes summary statistics (e.g., mean, standard deviation, median, etc.) for a specified column ("character string") in a data frame, grouped by one or more grouping variables in that data frame ("character strings"). Summary parameters can be customized and the results can be exported to an 'Excel' file.
}
\details{
The function computes the following summary statistics for the specified column:
\itemize{
\item \code{n}: number of observations
\item \code{mean}: mean
\item \code{sd}: standard deviation
\item \code{se}: standard error of the mean
\item \code{min}: minimum value
\item \code{max}: maximum value
\item \code{median}: median
\item \code{Q1}: first quartile
\item \code{Q3}: third quartile
}
Each of these summary statistics can be removed by setting e.g. \code{show_n = FALSE}, The results are grouped by the specified grouping variables and returned as a data frame. If \code{export_to_excel} is set to \code{TRUE}, the results are saved as an 'Excel' file in the working directory with a dynamically generated filename.

When only \code{data} and \code{data.column} is provided the function defaults to base:summary(data).
}
\examples{
# Example usage:
# Create a summary of mtcars for data column hp grouped by cyl and gear,
# and remove Q1 and Q3 from the output.
# Note that variable can be written as "hp" or as hp. Only data.frame must be data (no quotes)
summary_mtcars <- f_summary(mtcars, "hp", "cyl", "gear", show_Q1 = FALSE, show_Q3 = FALSE)
print(summary_mtcars)

# Create a summary for iris
summary_iris <- f_summary(iris, Sepal.Length, Species)

# Print the a table with column width of 10 characters and table length of 70 characters
print(summary_iris, col_width =  10, table_width = 70)

}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
