/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.Arrays;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;

public interface IResultVariableFactory
extends ISelf<Model> {
    default public IntVar sum(String name, IntVar ... toSum) {
        int lb = Arrays.stream(toSum).mapToInt(IntVar::getLB).sum();
        int ub = Arrays.stream(toSum).mapToInt(IntVar::getUB).sum();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub, true);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).sum(toSum, "=", result).post();
        }
        return result;
    }

    default public IntVar count(String name, int value, IntVar ... vars) {
        int lb = (int)Arrays.stream(vars).filter(v -> v.isInstantiatedTo(value)).count();
        int ub = (int)Arrays.stream(vars).filter(v -> v.contains(value)).count();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub, true);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).count(value, vars, result).post();
        }
        return result;
    }

    default public IntVar count(String name, IntVar value, IntVar ... vars) {
        if (value.isInstantiated()) {
            return this.count(name, value.getValue(), vars);
        }
        IntVar result = ((Model)this.ref()).intVar(name, 0, vars.length, true);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).count(value, vars, result).post();
        }
        return result;
    }

    default public IntVar element(String name, int[] table, IntVar index, int offset) {
        IntVar result = ((Model)this.ref()).intVar(name, index.stream().filter(v -> v >= offset && v < table.length + offset).map(v -> table[v - offset]).toArray());
        if (!result.isInstantiated()) {
            ((Model)this.ref()).element(result, table, index, offset).post();
        } else if (index.getLB() < offset || index.getUB() > offset + table.length - 1) {
            ((Model)this.ref()).member(index, offset, offset + table.length - 1).post();
        }
        return result;
    }

    default public IntVar element(String name, IntVar[] table, IntVar index, int offset) {
        int lb = index.stream().filter(v -> v >= offset && v < table.length + offset).map(v -> table[v - offset].getLB()).min().getAsInt();
        int ub = index.stream().filter(v -> v >= offset && v < table.length + offset).map(v -> table[v - offset].getUB()).max().getAsInt();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).element(result, table, index, offset).post();
        } else if (index.getLB() < offset || index.getUB() > offset + table.length - 1) {
            ((Model)this.ref()).member(index, offset, offset + table.length - 1).post();
        }
        return result;
    }

    default public IntVar min(String name, IntVar ... vars) {
        int lb = Arrays.stream(vars).mapToInt(IntVar::getLB).min().getAsInt();
        int ub = Arrays.stream(vars).mapToInt(IntVar::getUB).max().getAsInt();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).min(result, vars).post();
        }
        return result;
    }

    default public IntVar max(String name, IntVar[] vars) {
        int lb = Arrays.stream(vars).mapToInt(IntVar::getLB).min().getAsInt();
        int ub = Arrays.stream(vars).mapToInt(IntVar::getUB).max().getAsInt();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).max(result, vars).post();
        }
        return result;
    }

    default public IntVar argmin(String name, IntVar[] vars) {
        IntVar result = ((Model)this.ref()).intVar(name, 0, vars.length - 1, false);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).argmin(result, 0, vars).post();
        }
        return result;
    }

    default public IntVar argmax(String name, IntVar[] vars) {
        IntVar result = ((Model)this.ref()).intVar(name, 0, vars.length - 1, false);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).argmax(result, 0, vars).post();
        }
        return result;
    }

    default public SetVar union(String name, IntVar ... vars) {
        int[] lb = new int[]{};
        int[] ub = Arrays.stream(vars).flatMapToInt(IntVar::stream).distinct().toArray();
        SetVar result = ((Model)this.ref()).setVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).union(vars, result).post();
        }
        return result;
    }

    default public SetVar union(String name, SetVar ... sets) {
        int[] lb = new int[]{};
        int[] ub = Arrays.stream(sets).flatMapToInt(s -> Arrays.stream(s.getUB().toArray())).distinct().toArray();
        SetVar result = ((Model)this.ref()).setVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).union(sets, result).post();
        }
        return result;
    }

    default public SetVar intersection(String name, SetVar ... sets) {
        int[] lb = new int[]{};
        int[] ub = Arrays.stream(sets).flatMapToInt(s -> Arrays.stream(s.getUB().toArray())).distinct().toArray();
        SetVar result = ((Model)this.ref()).setVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).intersection(sets, result).post();
        }
        return result;
    }

    default public IntVar nbEmpty(String name, SetVar ... vars) {
        int lb = (int)Arrays.stream(vars).filter(s -> s.getUB().isEmpty()).count();
        int ub = (int)Arrays.stream(vars).filter(s -> s.getLB().isEmpty()).count();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub, true);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).nbEmpty(vars, result).post();
        }
        return result;
    }

    default public IntVar sum(String name, int[] values, int offset, SetVar indices) {
        int lb = Arrays.stream(indices.getLB().toArray()).map(i -> values[i - offset]).sum();
        int ub = Arrays.stream(indices.getUB().toArray()).map(i -> values[i - offset]).sum();
        IntVar result = ((Model)this.ref()).intVar(name, lb, ub, true);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).sumElements(indices, values, offset, result).post();
        }
        return result;
    }

    default public SetVar element(String name, IntVar index, SetVar[] sets, int offset) {
        int[] lb = new int[]{};
        int[] ub = index.stream().filter(i -> i >= offset && i < sets.length + offset).flatMap(i -> Arrays.stream(sets[i].getUB().toArray())).distinct().toArray();
        SetVar result = ((Model)this.ref()).setVar(name, lb, ub);
        if (!result.isInstantiated()) {
            ((Model)this.ref()).element(index, sets, offset, result).post();
        } else if (index.getLB() < offset || index.getUB() > offset + sets.length - 1) {
            ((Model)this.ref()).member(index, offset, offset + sets.length - 1).post();
        }
        return result;
    }
}

