% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{summary.resp_indicator}
\alias{summary.resp_indicator}
\title{Summary function for resp_indicator objects}
\usage{
\method{summary}{resp_indicator}(object, quantiles, ...)
}
\arguments{
\item{object}{An object of type resp_indicator created with a resp_* function.}

\item{quantiles}{A numeric vector with values raning from 0 to 1. Determines the
quantiles which are calculated. Default is \code{c(0,0.25,0.5,0.75,1)}.}

\item{...}{Additional arguments (currently not supported).}
}
\value{
A resp_indicator summary object. Works like a list with two elements:
\itemize{
\item \code{quantile_estimates}. A dataframe of estimated quantiles for the response quality indicators
calculated.
\item \code{mean_estimates}. A named vector with means of response quality indicators calculated.
}
}
\description{
Summarizes results of resp_* functions.
}
\examples{
resp_distributions(nep) |> summary()


}
