% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{simulate2GExperimentData}
\alias{simulate2GExperimentData}
\title{simulate2GExperimentData}
\usage{
simulate2GExperimentData(
  mean,
  sd,
  diff,
  GroupSize,
  type = "n",
  ExpAdj = 0,
  StdAdj = 0,
  BlockEffect = 0,
  BlockStdAdj = 0
)
}
\arguments{
\item{mean}{The mean (or rate for gamma data) of the baseline distribution}

\item{sd}{The standard deviation (or shape for gamma data) of the baseline distribution}

\item{diff}{The adjustment to the baseline mean for the alternative distribution.}

\item{GroupSize}{An integer defining the number of data items in each group.}

\item{type}{A string identifying the distribution used to simulate the data: 'n' for normal, 'ln' for log-normal, 'g' for gamma, 'lap' for Laplace.}

\item{ExpAdj}{An additional adjustment factor that is added to both the mean value. Defaults to zero.}

\item{StdAdj}{An additional adjustment factor that is added to both group variance (or rate for gamma data). Defaults to zero.}

\item{BlockEffect}{An additional factor that is added to the mean of the both groups (shape for the gamma distribution). Defaults to zero.}

\item{BlockStdAdj}{An additional factor that is added to the variance of both groups (shape for the gamma distribution). Defaults to zero.}
}
\value{
A table with two columns (BaselineData and AlternativeData) holding the data for each group. For lognormal data an additional two columns are added which return the log transformed data.
}
\description{
The function returns a two group data set based on one of four different distributions.
}
\examples{
set.seed(236)
simulate2GExperimentData(mean = 0, sd = 1, diff = 0.5, GroupSize = 10,
  type = "n", ExpAdj = 0, StdAdj = 0, BlockEffect = 0, BlockStdAdj = 0)
# A tibble: 10 x 2
#    BaselineData AlternativeData
#           <dbl>           <dbl>
#          <dbl>           <dbl>
# 1      -0.285           -0.255
# 2      -0.972            0.112
# 3      -0.549            1.36
# 4       1.05             1.47
# 5      -0.267            0.107
# 6      -0.137            0.395
# 7       1.30             1.27
# 8      -0.722            1.70
# 9      -0.525            0.264
# 10      -0.0222           0.787
set.seed(345)
simulate2GExperimentData(mean = 0, sd = 1, diff = 0.5, GroupSize = 10,
  type = "l", ExpAdj = 0, StdAdj = 0, BlockEffect = 0, BlockStdAdj = 0)
# A tibble: 10 x 4
#    BaselineData AlternativeData transBaselineData transAlternativeData
#          <dbl>           <dbl>             <dbl>                <dbl>
# 1        0.456          10.7             -0.785                 2.37
# 2        0.756           0.407           -0.280                -0.900
# 3        0.851           0.705           -0.161                -0.350
# 4        0.748           2.27            -0.291                 0.818
# 5        0.935           4.07            -0.0675                1.40
# 6        0.531           0.405           -0.634                -0.903
# 7        0.395           2.91            -0.928                 1.07
# 8        5.53            4.69             1.71                  1.55
# 9        5.23            0.602            1.65                 -0.508
# 10        6.11            2.23             1.81                  0.802

}
\author{
Barbara Kitchenham and Lech Madeyski
}
