% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14JVLC}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14JVLC}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14JVLC data}
\format{
A data frame with 36 rows and 12 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each experiment in the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each team of four participants, unique for the specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A , B}
\item{System}{<fct>|Software systems used in the experiment: Library (a software system to manage
 books and users of a library) and FilmCollection (a software system for the selling and the
 rental of films in a shop) in ExperimentStage1 and Rent (a car rental software to manage
 cars, customers, and reservations) and ECP (an E-Commerce Platform to order CDs and books via
 the Internet from an on line catalogue), in ExperimentStage2. }
\item{Treatment}{<fct>|Experimental Treatment: TPS vs F2F.}
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2 within each stage of the
 experiment}
\item{Time}{<dbl>|Dependent variable: The total time [min] to accomplish the requirement
engineering task.}
\item{Quality}{<dbl>|Dependent variable: The quality of the requirements engineering task. }
\item{CrossOverID}{<fct>|Crossover category: For a single 2 group crossover experiment, the
value is set to CO1 for each experiment stage.}
\item{ExperimentPeriod}{<fct>|ExperimentPeriod: The time period across both stages of the
 experiment.}
\item{ExperimentStage}{<fct>|ExperimentStage: 1 first stage, 2 second stage.}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14JVLC
}
\description{
Data illustrate correlations between results from individual participants in a cross-over
experiment conducted by Scanniello and Erra:
[1] G. Scanniello and U. Erra, 'Distributed modeling of use case diagrams with a method based on think-pair-square: Results from two controlled experiments', Journal of Visual Languages and
Computing, vol. 25, no. 4, pp. 494–517, 2014.
The experiment investigated whether a new method based on think-pair-square and its
implementation in a integrated communication/modeling environment (TPS approach) is as effective
as traditional face-to-face (F2F approach) for requirements elicitation. The experiment was performed in two stages using different software systems.
If you use this data set please cite:
[1] G. Scanniello and U. Erra, 'Distributed modeling of use case diagrams with a method based on
 think-pair-square: Results from two controlled experiments,” Journal of Visual Languages and
 Computing, vol. 25, no. 4, pp. 494–517, 2014.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, 'The Importance
of the Correlation between Results from Individual Participants in Crossover Experiments'
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14JVLC

}
\keyword{datasets}
