% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_compactsum.R
\name{xvar_function}
\alias{xvar_function}
\title{Create a summary table for an individual covariate}
\usage{
xvar_function(
  xvar,
  data,
  grp,
  covTitle = "",
  digits = 1,
  digits.cat = 0,
  iqr = TRUE,
  all.stats = FALSE,
  pvalue = TRUE,
  effSize = FALSE,
  show.tests = FALSE,
  percentage = "col"
)
}
\arguments{
\item{xvar}{character with the name of covariate to include in table}

\item{data}{dataframe containing data}

\item{grp}{character with the name of the grouping variable}

\item{covTitle}{character with the name of the covariate (predictor) column.
The default is to leave this empty for output or, for table only output to
use the column name 'Covariate'}

\item{digits}{numeric specifying the number of digits for summarizing mean
data. Otherwise, can specify for individual covariates using a vector of
digits where each element is named using the covariate name. If a covariate
is not in the vector the default will be used for it (default is 1).
See examples}

\item{digits.cat}{numeric specifying the number of digits for the proportions
when summarizing categorical data (default is 0)}

\item{iqr}{logical indicating if you want to display the interquartile range
(Q1, Q3) as opposed to (min, max) in the summary for continuous variables}

\item{all.stats}{logical indicating if all summary statistics (Q1, Q3 + min,
max on a separate line) should be displayed. Overrides iqr}

\item{pvalue}{logical indicating if you want p-values included in the table}

\item{effSize}{logical indicating if you want effect sizes and their 95\%
confidence intervals included in the table. Effect sizes calculated include
Cramer's V for categorical variables, and Cohen's d, Wilcoxon r,
Epsilon-squared, or Omega-squared for numeric/continuous variables}

\item{show.tests}{logical indicating if the type of statistical test and
effect size (if effSize = TRUE) used should be shown in a column beside the
p-values. Ignored if pvalue = FALSE}

\item{percentage}{choice of how percentages are presented, either column
(default) or row}
}
\value{
A data frame is returned
}
\description{
Create a summary table for an individual covariate
}
\keyword{internal}
