% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rm_cifsum}
\alias{rm_cifsum}
\title{Summarize cumulative incidence by group}
\usage{
rm_cifsum(
  data,
  time,
  status,
  group = NULL,
  eventcode = 1,
  cencode = 0,
  eventtimes,
  eventtimeunit,
  eventtimeLbls = NULL,
  CIwidth = 0.95,
  unformattedp = FALSE,
  na.action = "na.omit",
  showCounts = TRUE,
  showGraystest = TRUE,
  digits = 2,
  caption = NULL,
  tableOnly = FALSE
)
}
\arguments{
\item{data}{data frame containing survival data}

\item{time}{string indicating survival time variable}

\item{status}{string indicating event status variable; must have at least 3
levels, e.g. 0 = censor, 1 = event, 2 = competing risk}

\item{group}{string or character vector indicating the variable to group
observations by}

\item{eventcode}{numerical variable indicating event, default is 1}

\item{cencode}{numerical variable indicating censored observation, default is
0}

\item{eventtimes}{numeric vector specifying when event probabilities should
be calculated}

\item{eventtimeunit}{unit of time to suffix to the time column label if event
probabilities are requested, should be plural}

\item{eventtimeLbls}{if supplied, a vector the same length as eventtimes with
descriptions (useful for displaying years with data provided in months)}

\item{CIwidth}{width of the event probabilities, default is 95\%}

\item{unformattedp}{boolean indicating if you would like the p-value to be
returned unformatted (ie not rounded or prefixed with '<'). Should be used
in conjunction with the digits argument.}

\item{na.action}{default is to omit missing values, but can be set to throw
and error using na.action='na.fail'}

\item{showCounts}{boolean indicating if the at risk, events and censored
columns should be output, default is TRUE}

\item{showGraystest}{boolean indicating Gray's test should be included in the
final table, default is TRUE}

\item{digits}{the number of digits to report in the event probabilities,
default is 2.}

\item{caption}{table caption for markdown output}

\item{tableOnly}{should a dataframe or a formatted object be returned}
}
\value{
A character vector of the event table source code, unless
tableOnly=TRUE in which case a data frame is returned
}
\description{
Displays event counts and event rates at specified time points for the entire
cohort and by group. Gray's test of differences in cumulative incidence is
displayed.
}
\examples{
library(survival)
data(pbc)

# Event probabilities at various time points with replacement time labels
rm_cifsum(data=pbc,time='time',status='status',
eventtimes=c(1825,3650),eventtimeLbls=c(5,10),eventtimeunit='yr')

# Event probabilities by one group
rm_cifsum(data=pbc,time='time',status='status',group='trt',
eventtimes=c(1825,3650),eventtimeunit='day')


# Event probabilities by multiple groups
rm_cifsum(data=pbc,time='time',status='status',group=c('trt','sex'),
eventtimes=c(1825,3650),eventtimeunit='day')

}
