% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ggkmcif2Parameters}
\alias{ggkmcif2Parameters}
\title{Additional parameters passed to ggkmcif2}
\usage{
ggkmcif2Parameters(
  table.height = NULL,
  HR = FALSE,
  HR_pval = FALSE,
  conf.type = "log",
  main = NULL,
  stratalabs = NULL,
  strataname,
  stratalabs.table = NULL,
  strataname.table = strataname,
  median.text = FALSE,
  median.lines = FALSE,
  median.CI = FALSE,
  set.time.text = NULL,
  set.time.line = FALSE,
  set.time = 5,
  set.time.CI = FALSE,
  censor.marks = TRUE,
  censor.size = 3,
  censor.stroke = 1.5,
  fsize = 11,
  nsize = 3,
  lsize = 1,
  psize = 3.5,
  median.size = 3,
  median.pos = NULL,
  median.lsize = 1,
  set.size = 3,
  set.pos = NULL,
  set.lsize = 1,
  ylim = c(0, 1),
  linetype = NULL,
  xlim = NULL,
  legend.pos = NULL,
  pval.pos = NULL,
  event = c("col", "linetype"),
  flip.CIF = FALSE,
  cut = NULL,
  eventlabs = NULL,
  event.name = NULL,
  Numbers_at_risk_text = "Number at risk",
  HR.digits = 2,
  HR.pval.digits = 3,
  pval.digits = 3,
  median.digits = 3,
  set.time.digits = 3,
  print.n.missing = TRUE,
  returns = FALSE
)
}
\arguments{
\item{table.height}{Relative height of risk table (0-1)}

\item{HR}{boolean to specify if you want hazard ratios included in the plot}

\item{HR_pval}{boolean to specify if you want HR p-values in the plot}

\item{conf.type}{One of "none"(the default), "plain", "log" , "log-log" or
"logit". Only enough of the string to uniquely identify it is necessary.
The first option causes confidence intervals not to be generated. The
second causes the standard intervals curve +- k *se(curve), where k is
determined from conf.int. The log option calculates intervals based on
the cumulative hazard or log(survival). The log-log option bases the
intervals on the log hazard or log(-log(survival)), and the logit option
on log(survival/(1-survival)).}

\item{main}{String corresponding to main title. When NULL uses Kaplan-Meier
Plot s, and "Cumulative Incidence Plot for CIF"}

\item{stratalabs}{string corresponding to the labels of the covariate, when
NULL will use the levels of the covariate}

\item{strataname}{String of the covariate name default is  nicename(cov)}

\item{stratalabs.table}{String corresponding to the levels of the covariate
for the number at risk table, when NULL will use the levels of the
covariate. Can use a string of "-" when the labels are long}

\item{strataname.table}{String of the covariate name for the number at risk
table default is  nicename(cov}

\item{median.text}{boolean to specify if you want the median values added
to the legend (or as added text if there are no covariates), for KM only}

\item{median.lines}{boolean to specify if you want the median values added
as lines to the plot, for KM only}

\item{median.CI}{boolean to specify if you want the 95\\% confidence
interval with the median text (Only for KM)}

\item{set.time.text}{string for the text to add survival at a specified
time (eg. year OS)}

\item{set.time.line}{boolean to specify if you want the survival added as
lines to the plot at a specified point}

\item{set.time}{Numeric values of the specific time of interest, default is
5 (Multiple values can be entered)}

\item{set.time.CI}{boolean to specify if you want the 95\\% confidence
interval with the set time text}

\item{censor.marks}{logical value. If TRUE, includes censor marks (only for
KM curves)}

\item{censor.size}{size of censor marks, default is 3}

\item{censor.stroke}{stroke of censor marks, default is 1.5}

\item{fsize}{font size}

\item{nsize}{font size for numbers in the numbers at risk table}

\item{lsize}{line size}

\item{psize}{size of the pvalue}

\item{median.size}{size of the median text (Only when there are no
covariates)}

\item{median.pos}{vector of length 2 corresponding to the median position
(Only when there are no covariates)}

\item{median.lsize}{line size of the median lines}

\item{set.size}{size of the survival at a set time text (Only when there
are no covariates)}

\item{set.pos}{vector of length 2 corresponding to the survival at a set
point position (Only when there are no covariates)}

\item{set.lsize}{line size of the survival at set points}

\item{ylim}{vector of length 2 corresponding to limits of y-axis. Default
to NULL}

\item{linetype}{vector of line types; default is solid for all lines}

\item{xlim}{vector of length 2 corresponding to limits of x-axis. Default
to NULL}

\item{legend.pos}{Can be either a string corresponding to the legend
position ("left","top", "right", "bottom", "none") or a vector of length
2 corresponding to the legend position (uses normalized units (ie the
c(0.5,0.5) is the middle of the plot))}

\item{pval.pos}{vector of length 2 corresponding to the p-value position}

\item{event}{String specifying if the event should be mapped to the colour,
or linetype when plotting both events to colour = "col", line type}

\item{flip.CIF}{boolean to flip the CIF curve to start at 1}

\item{cut}{numeric value indicating where to divide a continuous covariate
(default is the median)}

\item{eventlabs}{String corresponding to the event type names}

\item{event.name}{String corresponding to the label of the event types}

\item{Numbers_at_risk_text}{String for the label of the number at risk}

\item{HR.digits}{Number of digits printed of the  hazard ratio}

\item{HR.pval.digits}{Number of digits printed of the hazard ratio pvalue}

\item{pval.digits}{Number of digits printed of the Gray's/log rank pvalue}

\item{median.digits}{Number of digits printed of the median pvalue}

\item{set.time.digits}{Number of digits printed of the probability at a
specified time}

\item{print.n.missing}{Logical, should the number of missing be shown
!Needs to be checked}

\item{returns}{Logical, if TRUE a list contain the plot and at risk table
is returned}
}
\description{
This section documents the additional parameters for \link{ggkmcif2}.
}
\keyword{internal}
