% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rgam.R
\name{summary.rgam}
\alias{summary.rgam}
\title{rgam summary routine}
\usage{
\method{summary}{rgam}(object, label = FALSE, index = NULL,
  which = NULL, ...)
}
\arguments{
\item{object}{Fitted \code{rgam} object.}

\item{label}{If \code{TRUE}, annotate the plot with variable labels. Default
is \code{FALSE}.}

\item{index}{The indices of the lambda hyperparameter which we want the plot
for. The default is to plot for the entire lambda path.}

\item{which}{Which values to plot. Default is all variables.}

\item{...}{Additional arguments to summary.}
}
\description{
Makes a two-panel plot of the rgam object showing coefficient paths.
}
\details{
A two panel plot is produced, that summarizes the linear components and
the nonlinear components, as a function of lambda. For the linear components,
it is the coefficient for each variable. For the nonlinear components, it is
the coefficient of the non-linear variable. Nothing is returned.
}
\examples{
set.seed(1)
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)

fit <- rgam(x, y)
opar <- par(mfrow = c(1, 2))
summary(fit)
par(opar)

# with labels, just variables 1 to 5
opar <- par(mfrow = c(1, 2))
summary(fit, label = TRUE, which = 1:5)
par(opar)

# as above, but just the first 30 values of lambda
opar <- par(mfrow = c(1, 2))
summary(fit, label = TRUE, which = 1:5, index = 1:30)
par(opar)

}
