% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{redist.subset}
\alias{redist.subset}
\title{Subset a shp}
\usage{
redist.subset(shp, adj, keep_rows, total_pop, ndists, pop_tol, sub_ndists)
}
\arguments{
\item{shp}{An sf object}

\item{adj}{A zero-indexed adjacency list. Created with
\code{redist.adjacency} if not supplied.}

\item{keep_rows}{row numbers of precincts to keep. Random submap selected if not supplied.}

\item{total_pop}{numeric vector with one entry for the population of each precinct.}

\item{ndists}{integer, number of districts in whole map}

\item{pop_tol}{The strength of the hard population constraint.}

\item{sub_ndists}{integer, number of districts in subset map}
}
\value{
a list containing the following components:
\item{shp}{The subsetted shp object}
\item{adj}{The subsetted adjacency list for shp}
\item{keep_rows}{The indices of the rows kept.}
\item{sub_ndists}{The number of districts in the subset.}
\item{sub_pop_tol}{The new parity constraint for a subset.}
}
\description{
Subsets a shp object along with its adjacency. Useful for running smaller analyses
on pairs of districts. Provide population, ndists, pop_tol, and sub_ndists to get proper
population parity constraints on subsets.
}
\concept{prepare}
