% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRecursions.R, R/getRecursions.data.frame.R,
%   R/getRecursions.move.R, R/getRecursions.move2.R, R/getRecursions.movestack.R
\name{getRecursions}
\alias{getRecursions}
\alias{getRecursions.data.frame}
\alias{getRecursions.Move}
\alias{getRecursions.move2}
\alias{getRecursions.MoveStack}
\title{Calculates recursion information from the trajectory}
\usage{
getRecursions(
  x,
  radius,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

\method{getRecursions}{data.frame}(
  x,
  radius,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

\method{getRecursions}{Move}(
  x,
  radius,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

\method{getRecursions}{move2}(
  x,
  radius,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

\method{getRecursions}{MoveStack}(
  x,
  radius,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)
}
\arguments{
\item{x}{Either a data frame, move2, \link[move]{Move-class}, or \link[move]{MoveStack} object. For a data frame, 
the trajectory data with four columns (the x-coordinate, the y-coordinate, the datetime, and the animal id).}

\item{radius}{numeric radius to use in units of the (x,y) location data to detect recursions.}

\item{threshold}{a time difference (in units \code{timeunits}) to ignore excursions outside the radius. Defaults to 0.}

\item{timeunits}{character string specifying units to calculate time differences in for the time spans inside the radius and since the 
visit in \code{revisitStats}. Defaults to hours.}

\item{verbose}{\code{TRUE} to output complete information (can be large for large input data frames) or 
\code{FALSE} to output basic information.}
}
\value{
A list with several components, \code{revisits} and \code{residenceTime}
are vectors of the same length as the \code{x} dataframe. \code{revisits} is the number of revisits for each 
location, where 1 means that there were 
no revisits, only the initial visit. \code{residenceTime} is the total time spent withing the radius. \code{radius}
is the specified radius used for all the calculations. \code{timeunits} is the specified time units used to specify
timespans.

When \code{verbose = TRUE}, additional information 
is also returned, \code{dists} and \code{revisitStats}. Next, \code{dists} gives the distance matrix between
all locations. Finally, \code{revisitStats} gives further statistics on each visit. These are calculated 
per location (i.e., no aggregation of nearby points is performed), and give the index and location
of the point of the track at the center of the radius, the radius entrance and exit time of the track for that 
visit, how much time was spent inside the radius, and how long since the last visit (\code{NA} for the first visit).
}
\description{
A circle of radius R is drawn around each point in the trajectory. The number of
revisits is calculated as the number of segments of the trajectory passing through that circle.
}
\details{
For each point in the trajectory, a circle of radius R is drawn around that point.
Then the number of segments of the trajectory passing through that circle is counted. This is
the number of revisits, so each point will have at least one revisit (the initial visit). For each 
revisit, the time spent inside the circle is calculated, as well as the time since the last 
visit (NA for the first visit). In order to calculate the time values, the crossing time of the
radius is calculated by assuming linear movement at a constant speed between the points inside
and outside the circle.

\strong{Projection.} Consider the projection used. Since segments are counted passing through circles
drawn around points, an equal area projection would ensure similar size comparisons (e.g., \code{\link[move]{spTransform}}). 

Either single or multiple individuals are supported, but be aware that this function will be slow with
large amounts of data (e.g. millions of points), so consider pre-specifying the locations 
(\code{\link{getRecursionsAtLocations}}) or use clustering. Multiple individuals are handled via the \code{id} column of the 
data.frame or using a move2 or \link[move]{MoveStack} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{getRecursions(data.frame)}: Get recursions for a data.frame object consisting of columns x, y, datetime, and id

\item \code{getRecursions(Move)}: Get recursions for a \link[move]{Move-class} object

\item \code{getRecursions(move2)}: Get recursions for a move2 object (for details see \code{vignette("programming_move2_object", package = "move2")})

\item \code{getRecursions(MoveStack)}: Get recursions for a \link[move]{MoveStack} object

}}
\examples{
data(martin)
revisits = getRecursions(martin, radius = 1)
plot(revisits, martin, legendPos = c(10, -15))
drawCircle(10, -10, 1)

}
\seealso{
\code{\link{getRecursionsAtLocations}}
}
\author{
Chloe Bracis <cbracis@uw.edu>
}
