% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo.geefit.R
\name{pseudo.geefit}
\alias{pseudo.geefit}
\title{Function that makes GEE model fit for recurrent pseudo-observations}
\usage{
pseudo.geefit(pseudodata, covar_names)
}
\arguments{
\item{pseudodata}{Data set containing pseudo-observations. Expecting output from pseudo.twodim()}

\item{covar_names}{Vector with covariate names to be found in "pseudodata". E.g. covar_names = c("Z", "Z1")}
}
\value{
An object of class \code{pseudo.geefit}.
\itemize{
\item{\code{xi}} {contains the estimated model parameters}
\item{\code{sigma}} {contains the estimated variance matrix corresponding to \code{xi}}
}
}
\description{
This function fits a GEE model based on pseudo-observations of the marginal mean function, and
the survival probability or cumulative incidences of two death causes
as returned by \code{pseudo.onedim()} (marginal mean function), or
\code{pseudo.twodim()} (marginal mean function and survival probability), or
\code{pseudo.threedim()} (marginal mean function and cumulative incidences of death causes 1 and 2)
}
\examples{
# Bladder cancer data from survival package
require(survival)

# Make a three level status variable
bladder1$status3 <- ifelse(bladder1$status \%in\% c(2, 3), 2, bladder1$status)

# Add one extra day for the two patients with start=stop=0
# subset(bladder1, stop <= start)
bladder1[bladder1$id == 1, "stop"] <- 1
bladder1[bladder1$id == 49, "stop"] <- 1

# Restrict the data to placebo and thiotepa
bladdersub <- subset(bladder1, treatment \%in\% c("placebo", "thiotepa"))

# Make treatment variable two-level factor
bladdersub$Z <- as.factor(ifelse(bladdersub$treatment == "placebo", 0, 1))
levels(bladdersub$Z) <- c("placebo", "thiotepa")

head(bladdersub)

# Two-dimensional (bivariate pseudo-obs) model fit

# Computation of pseudo-observations
pseudo_bladder_2d <- pseudo.twodim(tstart = bladdersub$start,
                                   tstop = bladdersub$stop,
                                   status = bladdersub$status3,
                                   id = bladdersub$id,
                                   covar_names = "Z",
                                   tk = c(30),
                                   data = bladdersub)

# Data in wide format
head(pseudo_bladder_2d$outdata)

# Data in long format
head(pseudo_bladder_2d$outdata_long)

# GEE fit
fit_bladder_2d <- pseudo.geefit(pseudodata = pseudo_bladder_2d,
                                covar_names = c("Z"))
fit_bladder_2d
}
\references{
Furberg, J.K., Andersen, P.K., Korn, S. et al. Bivariate pseudo-observations for recurrent event analysis with terminal events. Lifetime Data Anal (2021). https://doi.org/10.1007/s10985-021-09533-5
}
\keyword{recurrentpseudo}
