% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recolorImage.R
\name{recoloredImage}
\alias{recoloredImage}
\title{Get recolored image from a recolorize object}
\usage{
recoloredImage(recolorize_obj, type = c("array", "raster"))
}
\arguments{
\item{recolorize_obj}{An object of class \code{recolorize}. Must include
a pixel assignment matrix and matrix of color centers.}

\item{type}{Type of image to return. One of either "array" or "raster".
Arrays are numeric RGB arrays (larger, but easier to do operations on),
rasters are matrices of hex codes (smaller, only really good for plotting).}
}
\value{
A numeric image array (if \code{type = array}) or a matrix of hex codes (
if \code{type = raster}).
}
\description{
\code{recolorize} objects use a numeric color map and a matrix of
color centers to make recolored images, since this is a lighter weight
and more flexible format. This function generates a colored image
from those values for plotting.
}
