% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unknown.R
\name{step_unknown}
\alias{step_unknown}
\title{Assign missing categories to "unknown"}
\usage{
step_unknown(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  new_level = "unknown",
  objects = NULL,
  skip = FALSE,
  id = rand_id("unknown")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{new_level}{A single character value that will be assigned to new factor
levels.}

\item{objects}{A list of objects that contain the information on factor
levels that will be determined by \code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_unknown()} creates a \emph{specification} of a recipe step that will assign
a missing value in a factor level to \code{"unknown"}.
}
\details{
The selected variables are adjusted to have a new level (given by
\code{new_level}) that is placed in the last position.

Note that if the original columns are character, they will be converted to
factors by this step.

If \code{new_level} is already in the data given to \code{\link[=prep]{prep()}}, an error is thrown.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{value} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{statistic}{character, the factor levels for the new values}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

rec <-
  recipe(~ city + zip, data = Sacramento) |>
  step_unknown(city, new_level = "unknown city") |>
  step_unknown(zip, new_level = "unknown zip") |>
  prep()

table(bake(rec, new_data = NULL) |> pull(city),
  Sacramento |> pull(city),
  useNA = "always"
) |>
  as.data.frame() |>
  dplyr::filter(Freq > 0)

tidy(rec, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dummy_names]{dummy_names()}}

Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
