% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n2.R
\name{plotn2sim}
\alias{plotn2sim}
\title{Mark-Recapture Sample Size Via Simulation}
\usage{
plotn2sim(
  N,
  n1,
  conf = c(0.99, 0.95, 0.85, 0.8, 0.75),
  n2range = NULL,
  n2step = NULL,
  estimator = "Chapman",
  nsim = 10000,
  accrange = 1,
  ...
)
}
\arguments{
\item{N}{The best guess at true abundance}

\item{n1}{The size of the first (or second) sampling event}

\item{conf}{A vector of the desired levels of confidence to investigate.
Allowed values are any of \code{c(0.99,0.95,0.85,0.8,0.75)}.  Defaults to
all of \code{c(0.99,0.95,0.85,0.8,0.75)}.}

\item{n2range}{A two-element vector describing the range of sample sizes to
investigate.  If the default (\code{NULL}) is accepted, an appropriate
value will be chosen.}

\item{n2step}{The step size between sample sizes to investigate.  If the
default (\code{NULL}) is accepted, an appropriate value will be chosen.}

\item{estimator}{The abundance estimator to use.  Allowed values are
\code{"Chapman"}, \code{"Petersen"}, and \code{"Bailey"}. Defaults to
\code{"Chapman"}.}

\item{nsim}{The number of replicates.  Defaults to 10000.}

\item{accrange}{The maximum level of relative accuracy for plotting.
Defaults to 1.}

\item{...}{Additional plotting parameters}
}
\description{
Produces a plot of the simulated relative accuracy of a
  mark-recapture abundance estimator for various sample sizes.  This may be a
  better representation of the sample size - accuracy relationship than that
  provided by \link{n2RR}.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
plotn2sim(N=1000, n1=100)
}
\seealso{
\link{n2RR}, \link{plotn1n2simmatrix}
}
\author{
Matt Tyers
}
