% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetime-constants.R, R/datetime.R
\docType{data}
\name{OPT_LEADING_0}
\alias{OPT_LEADING_0}
\alias{DTSEP}
\alias{CENTURY}
\alias{CENTURY_IN}
\alias{YEAR}
\alias{YEAR2}
\alias{YEAR4}
\alias{MONTH}
\alias{MONTH_IN}
\alias{WEEK_OF_YEAR}
\alias{WEEK_OF_YEAR_IN}
\alias{DAY}
\alias{DAY_IN}
\alias{DAY_SINGLE}
\alias{DAY_OF_YEAR}
\alias{DAY_OF_YEAR_IN}
\alias{WEEKDAY1}
\alias{WEEKDAY0}
\alias{HOUR24}
\alias{HOUR24_SINGLE}
\alias{HOUR24_IN}
\alias{HOUR12}
\alias{HOUR12_SINGLE}
\alias{HOUR12_IN}
\alias{MINUTE}
\alias{MINUTE_IN}
\alias{SECOND}
\alias{SECOND_IN}
\alias{FRACTIONAL_SECOND}
\alias{FRACTIONAL_SECOND_IN}
\alias{AM_PM}
\alias{TIMEZONE_OFFSET}
\alias{TIMEZONE}
\alias{ISO_DATE}
\alias{ISO_DATE_IN}
\alias{ISO_TIME}
\alias{ISO_TIME_IN}
\alias{ISO_DATETIME}
\alias{ISO_DATETIME_IN}
\alias{YMD}
\alias{YMD_IN}
\alias{YDM}
\alias{YDM_IN}
\alias{MYD}
\alias{MYD_IN}
\alias{MDY}
\alias{MDY_IN}
\alias{DYM}
\alias{DYM_IN}
\alias{DMY}
\alias{DMY_IN}
\alias{HMS}
\alias{HMS_IN}
\alias{HM}
\alias{HM_IN}
\alias{MS}
\alias{MS_IN}
\alias{DateTime}
\alias{datetime}
\title{Date-time regexes}
\format{
An object of class \code{character} of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.
}
\usage{
OPT_LEADING_0

DTSEP

CENTURY

CENTURY_IN

YEAR

YEAR2

YEAR4

MONTH

MONTH_IN

WEEK_OF_YEAR

WEEK_OF_YEAR_IN

DAY

DAY_IN

DAY_SINGLE

DAY_OF_YEAR

DAY_OF_YEAR_IN

WEEKDAY1

WEEKDAY0

HOUR24

HOUR24_SINGLE

HOUR24_IN

HOUR12

HOUR12_SINGLE

HOUR12_IN

MINUTE

MINUTE_IN

SECOND

SECOND_IN

FRACTIONAL_SECOND

FRACTIONAL_SECOND_IN

AM_PM

TIMEZONE_OFFSET

TIMEZONE

ISO_DATE

ISO_DATE_IN

ISO_TIME

ISO_TIME_IN

ISO_DATETIME

ISO_DATETIME_IN

YMD

YMD_IN

YDM

YDM_IN

MYD

MYD_IN

MDY

MDY_IN

DYM

DYM_IN

DMY

DMY_IN

HMS

HMS_IN

HM

HM_IN

MS

MS_IN

datetime(x, locale = NULL, io = c("output", "input"))
}
\arguments{
\item{x}{A \code{\link[base]{strptime}}-style date-time format string.}

\item{locale}{A string specifying a locale.}

\item{io}{Are you trying to match output or input?  The latter is less
strict about leading zeroes and spaces.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Compound regex constants for matching ISO 8601 dates and times.
}
\note{
\code{"\%O[dHImMUVwWy]"}, \code{"\%E[cCyYxX]"}, \code{"\%x"}, \code{"\%X"}
and \code{"\%+"} are supposed to be locale-dependent upon output,
but implementing this in an OS-portable way seems to be much more effort
than it's worth.
}
\examples{
datetime("\%m/\%d/\%Y")             # match US style dates
twelve_or_twentyfour <- rebus.base::or("\%H", "\%I\%p")
datetime(twelve_or_twentyfour) # match hours in 24h or 12h format

\dontrun{
# week days and months can be matched in any locale
if(.Platform$OS.type == "windows")
{
  fr_FR <- "French_France"
  ar_QA <- "Arabic_Qatar"
} else if(Sys.info()["sysname"] != "Darwin") # mac
{
  fr_FR <- "fr_FR"
  ar_QA <- "ar_QA"
} else if(Sys.info()["sysname"] != "Linux")
{
  fr_FR <- "fr_FR.utf8"
  ar_QA <- "ar_QA.utf8"
}
datetime("\%a \%A \%b \%B", fr_FR)
datetime("\%a \%A \%b \%B", ar_QA)

# All letter tokens.  Lots of output.
x <- paste0("\%", c(letters, LETTERS))
stats::setNames(datetime(x), x)
}

# Individual date-time components
DTSEP             # optional selected punctuation or space
CENTURY           # exactly two digits
YEAR              # one to four digits
YEAR2             # exactly two digits
YEAR4             # exactly four digits
MONTH             # number from 1 to 12, leading zero
WEEK_OF_YEAR      # number from 0 to 53, leading zero
DAY               # number from 1 to 31, leading zero
DAY_SINGLE        # leading space
HOUR24            # 24 hour clock, leading zero
HOUR12            # 12 hour clock, leading zero
HOUR24_SINGLE     # 24 hour clock, leading space
HOUR12_SINGLE     # 12 hour clock, leading space
MINUTE            # number from 0 to 59, leading zero
SECOND            # number from 0 to 61 (leap seconds), leading zero
FRACTIONAL_SECOND # a second optional decimal point and up to 6 digits
AM_PM             # AM or PM, any case
TIMEZONE_OFFSET   # optional plus or minus, then four digits
TIMEZONE          # Any value returned by OlsonNames()
# ISO 8601 formats
ISO_DATE          # \%Y-\%m-\%d
ISO_TIME          # \%H:\%M:\%S
ISO_DATETIME      # ISO_DATE followed by ISO_TIME, separated by space or "T".
# Compound forms, separated by DTSEP
YMD
YDM
MYD
MDY
DYM
DMY
HMS
HM
MS

# Some forms have less strict alternatives for input (with an '_IN' suffix).
CENTURY_IN
MONTH_IN
WEEK_OF_YEAR_IN
DAY_IN
HOUR24_IN
HOUR12_IN
MINUTE_IN
SECOND_IN
FRACTIONAL_SECOND_IN
ISO_DATE_IN
ISO_TIME_IN
ISO_DATETIME_IN
YMD_IN
YDM_IN
MYD_IN
MDY_IN
DYM_IN
DMY_IN
HMS_IN
HM_IN
MS_IN

dates <- seq(as.Date("2000-01-01"), as.Date("2001-01-01"), "1 day")
datetimes <- seq(as.POSIXct(Sys.Date()), as.POSIXct(Sys.Date() + 1), "1 sec")
times <- substring(format(datetimes), 12, 19)
stopifnot(
  all(grepl(ISO_DATE, dates)),
  all(grepl(ISO_TIME, times)),
  all(grepl(ISO_DATETIME, datetimes))
)
non_dates <- c(
  "2000-13-01", "2000-01-32", "2000-00-01", "2000-01-00"
)
non_times <- c(
  "24:00:00", "23:60:59", "23:59:62", "23 59 59"
)
stopifnot(
  all(!grepl(ISO_DATE, non_dates)),
  all(!grepl(ISO_TIME, non_times))
)
}
\seealso{
\code{\link[base]{strptime}} that describes formatting codes,
\code{\link[rebus.base]{ClassGroups}}, \code{\link[base]{Sys.setlocale}}
}
\keyword{datasets}
