% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{calc_AML}
\alias{calc_AML}
\title{Compute AML}
\usage{
calc_AML(
  WLAa,
  WLAc,
  WLAhh,
  cv,
  n_samples = 4,
  prob_LTA = 0.99,
  percentile_AML = 0.95
)
}
\arguments{
\item{WLAa}{Numeric. Acute wasteload allocation (WLA). All WLA units should be identical.}

\item{WLAc}{Numeric. Chronic wasteload allocation (WLA). All WLA units should be identical.}

\item{WLAhh}{Numeric. Human health wasteload allocation (WLA). All WLA units should be identical.}

\item{cv}{Numeric. Coefficient of variation (CV) of effluent data. See cv_adj function.}

\item{n_samples}{Numeric. Number of sample observations.}

\item{prob_LTA}{Numeric (fraction). Allowable exceedance probability of the WLA used to estimate long-term average (LTA).}

\item{percentile_AML}{Numeric (fraction). Lognormal distribution location for AML.}
}
\value{
Numeric value in same units as the WLAs.
}
\description{
Compute average monthly effluent limitation (AML) according to methods in EPA's Technical Support Document for Water Quality-based Toxics Control.
}
\examples{
calc_AML(WLAa=4, WLAc=1, WLAhh=10, cv=0.6)

}
