% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_column.R
\name{merge_column}
\alias{merge_column}
\title{Merge two columns together in a specified arrangement.}
\usage{
merge_column(
  data,
  merged_name = NULL,
  merged_position = "right",
  merged_size = 12,
  merged_color = "#777",
  merged_weight = "normal",
  merged_style = "normal",
  merged_decoration = "normal",
  size = 14,
  color = NULL,
  weight = "bold",
  style = "normal",
  decoration = NULL,
  spacing = 0
)
}
\arguments{
\item{data}{Dataset containing either a text or numeric column.}

\item{merged_name}{The name of the column to merge with the existing column.
The column can contain either numeric or non-numeric data.
Only a single column can be provided.
Default is NULL.}

\item{merged_position}{The position of the merged column in relation to the existing column.
Options are 'right', 'left', 'above', or 'below'.
Default is right.}

\item{merged_size}{The size of the text of the merged column.
Default is 12.}

\item{merged_color}{The color of the text of the merged column.
Default is #777.}

\item{merged_weight}{The font weight of the text of the merged column.
Options are "bold" or "normal".
Default is "normal".}

\item{merged_style}{The style of the text of the merged column.
Options are "normal" or "italic".
Default is "normal".}

\item{merged_decoration}{The decoration of the text of the merged column.
For example, add an underline, overline, or line-through to the text.
Default is NULL.}

\item{size}{The size of the text displayed in the current column.
Default is 12.}

\item{color}{The color of the text displayed in the current column.
Default is NULL.}

\item{weight}{The font weight of the text displayed in the current column.
Options are "bold" or "normal".
Default is "normal".}

\item{style}{The style of the text displayed in the current column.
Options are "normal" or "italic".
Default is "normal".}

\item{decoration}{The decoration of the text displayed in the current column.
For example, add an underline, overline, or line-through to the text.
Default is NULL.}

\item{spacing}{The spacing between the merged and existing columns.
A value greater than 0 creates more space between, a value less than 0 creates less space.
Default is 0.}
}
\value{
a function that merges two columns together.
}
\description{
The `merge_column()` function can be used to merge and style values from two columns within a reactable table.
    `merge_column()` works with both numeric and non-numeric columns.
    The style/format of both the current column and merged column can be controlled via size, color, weight, and text decoration.
    Any style parameters that start with "merged_" will control the column that is being merged and specified by `merged_name`.
    Any style parameters that do not start with "merged_" control the current column you are within.
    The position of the column to be merged relative to the current column can be controlled with `merged_position`.
    The position options for the merged column are above, below, left, or right to the current column.
    The spacing between the current column and the merged column can be controlled with `spacing`.
    `merge_column()` needs to placed within the cell argument in reactable::colDef.
}
\examples{
data <- MASS::Cars93[20:49, c("Manufacturer", "Model", "MPG.city", "MPG.highway")]

## Stack text from one column with another column:
reactable(
data,
columns = list(
Manufacturer = colDef(name = "Manufacturer/Model",
                      cell = merge_column(data, merged_name = "Model"
                      )),
Model = colDef(show = FALSE)))

## Control the appearance of both the current and merged columns:
reactable(
data,
columns = list(
Manufacturer = colDef(name = "Manufacturer/Model",
                      cell = merge_column(data,
                                          merged_name = "Model",
                                          merged_size = 16,
                                          merged_color = "blue",
                                          merged_style = "italic",
                                          size = 18,
                                          color = "red"
                                          )),
Model = colDef(show = FALSE)))

## Combine both numeric and non-numeric columns together:
reactable(
data,
columns = list(
Model = colDef(name = "Model/MPG Highway",
                  cell = merge_column(data,
                                      merged_name = "MPG.highway",
                                      merged_position = "below",
                                      merged_size = 20,
                                      merged_color = "green"
)),
MPG.highway = colDef(show = FALSE),
MPG.city = colDef(show = FALSE)))
}
