% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_boundPoly}
\alias{ddi_boundPoly}
\title{boundPoly and its child nodes}
\usage{
ddi_boundPoly(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
The geographic bounding polygon field allows the creation of multiple
polygons to describe in a more detailed manner the geographic area covered
by the dataset. It should only be used to define the outer boundaries of a
covered area. For example, in the United States, such polygons can be created
to define boundaries for Hawaii, Alaska, and the continental United States,
but not interior boundaries for the contiguous states. This field is used to
refine a coordinate-based search, not to actually map an area. If the
boundPoly element is used, then geoBndBox MUST be present, and all points
enclosed by the boundPoly MUST be contained within the geoBndBox. Elements
westBL, eastBL, southBL, and northBL of the geoBndBox should each be
represented in at least one point of the boundPoly description. More
information on these elements, especially their allowed attributes, can be
found in the references.
}
\details{
\emph{Parent nodes}

\code{boundPoly} is contained in \code{sumDscr}.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_polygon]{ddi_polygon()}}
}
}

\examples{
# ddi_boundPoly requires ddi_polygon(). ddi_polygon then requires ddi_point()
# which requires ddi_gringLat() and ddi_gringLon()

ddi_boundPoly(ddi_polygon(
                ddi_point(
                   ddi_gringLat("42.002207"), 
                   ddi_gringLon("-120.005729004")
                 )
               )
             )

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/boundPoly.html}{boundPoly documentation}
}
