% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_cn.R
\name{dc_cn}
\alias{dc_cn}
\title{DataCite content negotation}
\usage{
dc_cn(dois, format = "bibtex", style = "apa", locale = "en-US", ...)
}
\arguments{
\item{dois}{(character) one or more DOIs}

\item{format}{Name of the format. One of "rdf-xml", "turtle",
"citeproc-json", "schemaorg", "codemeta", "text", "ris", "bibtex"
(default), "datacite-xml", "datacite-json", "bibentry", or
"jats".}

\item{style}{a CSL style (for text format only). See
‘rcrossref::get_styles()’ for options. Default: 'apa'. If there's
a style that DataCite doesn't support you'll get a
(500) Internal Server Error}

\item{locale}{Language locale. See ‘?Sys.getlocale’}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\description{
DataCite content negotation
}
\examples{
\dontrun{
dc_cn("10.5281/zenodo.50213")
dc_cn(c("10.5281/zenodo.50213", "10.5281/zenodo.57081"), "text")
dc_cn(c("a-bad-doi", "10.5281/zenodo.50213", "10.5281/zenodo.57081"), "text")
}
}
\references{
https://support.datacite.org/docs/datacite-content-resolver
}
\seealso{
see also \code{rcrossref::cr_cn} for a more general purpose
content negotation interface
}
