% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rct3.R
\name{print.rct3}
\alias{print.rct3}
\title{Print an rct3 fit}
\usage{
\method{print}{rct3}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{an object of class rct3 - an output from the rct3 function.}

\item{digits}{optional integer for how much to round the values in the
output tables.}

\item{...}{additional arguments to print.data.frame}
}
\value{
invisibly returns a summary data frame.
}
\description{
Print an rct3 fit showing the model settings and predicted recruitments
}
\examples{
# load recruitment data
data(recdata)

formula <-
 recruitment ~ NT1 + NT2 + NT3 + NAK1 + NAK2 + NAK3 +
               RT1 + RT2 + RT3 + EC01 + ECO2 + ECO3

my_rct3 <- rct3(formula, recdata, predictions = 2012:2017, shrink = TRUE)

# see a short summary
my_rct3

# for a full summary do:
summary(my_rct3)

# the components are here:
my_rct3$rct3
my_rct3$rct3.summary

# predicted recruitment
t(my_rct3$rct3.summary["WAP"])

}
\seealso{
\code{\link{rct3}} run a calibrated regression to predict rectruitment.

\code{\link{summary.rct3}} summarise a rct3 object

\code{\link{rct3-package}} gives an overview of the package.
}
