% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-varsstat.R, R/op-cdo-varsavg.R,
%   R/op-cdo-varsmax.R, R/op-cdo-varsmean.R, R/op-cdo-varsmin.R,
%   R/op-cdo-varsrange.R, R/op-cdo-varsstd.R, R/op-cdo-varsstd1.R,
%   R/op-cdo-varssum.R, R/op-cdo-varsvar.R, R/op-cdo-varsvar1.R
\name{varsstat}
\alias{varsstat}
\alias{cdo_varsavg}
\alias{cdo_varsmax}
\alias{cdo_varsmean}
\alias{cdo_varsmin}
\alias{cdo_varsrange}
\alias{cdo_varsstd}
\alias{cdo_varsstd1}
\alias{cdo_varssum}
\alias{cdo_varsvar}
\alias{cdo_varsvar1}
\title{Statistical values over all variables}
\usage{
cdo_varsavg(ifile, ofile = NULL)

cdo_varsmax(ifile, ofile = NULL)

cdo_varsmean(ifile, ofile = NULL)

cdo_varsmin(ifile, ofile = NULL)

cdo_varsrange(ifile, ofile = NULL)

cdo_varsstd(ifile, ofile = NULL)

cdo_varsstd1(ifile, ofile = NULL)

cdo_varssum(ifile, ofile = NULL)

cdo_varsvar(ifile, ofile = NULL)

cdo_varsvar1(ifile, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module computes statistical values over all variables for each timestep. Depending on the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation is written to outfile. All input variables need to have the same gridsize and the same number of levels.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{varsmin    Variables minimum
           For every timestep the minimum over all variables is computed.
varsmax    Variables maximum
           For every timestep the maximum over all variables is computed.
varsrange  Variables range
           For every timestep the range over all variables is computed.
varssum    Variables sum
           For every timestep the sum over all variables is computed.
varsmean   Variables mean
           For every timestep the mean over all variables is computed.
varsavg    Variables average
           For every timestep the average over all variables is computed.
varsstd    Variables standard deviation
           For every timestep the standard deviation over all variables is computed. Normalize by n.
varsstd1   Variables standard deviation (n-1)
           For every timestep the standard deviation over all variables is computed. Normalize by (n-1).
varsvar    Variables variance
           For every timestep the variance over all variables is computed. Normalize by n.
varsvar1   Variables variance (n-1)
           For every timestep the variance over all variables is computed. Normalize by (n-1).
}\if{html}{\out{</div>}}
}
