% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thr_mblt.R
\name{thr_mblt}
\alias{thr_mblt}
\title{Compute model-based thresholds}
\usage{
thr_mblt(dn, intercept, slope)
}
\arguments{
\item{dn}{numeric vector or \link[terra:SpatRaster-class]{terra::SpatRaster}. Background digital
number. Values must be normalized; if taken from JPEG, apply gamma back
correction.}

\item{intercept, slope}{numeric vectors of length one. Linear coefficients.}
}
\value{
An object of the same class and dimensions as \code{dn}.
}
\description{
Compute threshold values from background digital numbers (DN) using
Equation 1 in \insertCite{Diaz2018;textual}{rcaiman}, a linear function
whose slope can be weighted.
}
\details{
The model was derived from canopy targets (perforated, rigid, dark
surfaces) backlit under homogeneous illumination, photographed with a
Nikon Coolpix 5700 in JPEG mode. Images were gamma-back-corrected with
a default gamma of 2.2 (see \code{\link[=invert_gamma_correction]{invert_gamma_correction()}}). Results showed that the optimal
threshold is linearly related to the background DN (see Figures 1 and 7
in \insertCite{Diaz2018;textual}{rcaiman}). This shifted the goal from
estimating an optimal threshold \insertCite{Song2014;textual}{rcaiman} to
estimating the background DN as if the canopy were absent, as proposed by
\insertCite{Lang2010;textual}{rcaiman}.

To apply the weighting parameter (w) from Equation 1, supply \code{slope} as
\eqn{slope \times w}.

Equation 1 was developed with 8-bit images. New coefficients should be
calibrated in the 0–255 domain, which is what \code{\link[=thr_mblt]{thr_mblt()}} expects, even
though the \code{dn} argument must be normalized. This design choice harmonizes
behavior across the package.
}
\note{
Users are encouraged to acquire raw files (see \code{\link[=read_caim_raw]{read_caim_raw()}}).
}
\examples{
thr_mblt(invert_gamma_correction(125), -7.8, 0.95 * 0.5)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=normalize_minmax]{normalize_minmax()}}, \code{\link[=invert_gamma_correction]{invert_gamma_correction()}}
}
