% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complementary_gradients.R
\name{complementary_gradients}
\alias{complementary_gradients}
\title{Calculate complementary gradients}
\usage{
complementary_gradients(caim)
}
\arguments{
\item{caim}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with three layers named
\code{"Red"}, \code{"Green"}, and \code{"Blue"}. Digital numbers should be linearly
related to radiance. See \code{\link[=read_caim_raw]{read_caim_raw()}} for details.}
}
\value{
Numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with three layers and the same
geometry as \code{caim}. The layers (\code{"green_magenta"}, \code{"yellow_blue"},
\code{"red_cyan"}) are chromatic gradients modulated by brightness.
}
\description{
Compute three color-opponent gradients to enhance the visual separation
between sky and canopy in hemispherical photographs, particularly under
diffuse light or complex cloud patterns.
}
\details{
The method exploits chromatic differences between the red, green, and blue
bands, following a simplified opponent-color logic. Each gradient is
normalized by total brightness and modulated by a logistic contrast
function to reduce the influence of underexposed regions:
\itemize{
\item \code{"green_magenta"} = \eqn{(R - G + B) / (R + G + B)} · logistic(brightness)
\item \code{"yellow_blue"}   = \eqn{(-R - G + B) / (R + G + B)} · logistic(brightness)
\item \code{"red_cyan"}      = \eqn{(-R + G + B) / (R + G + B)} · logistic(brightness)
}

The \code{logistic(brightness)} term is computed as:
\deqn{
\text{logistic}(x) = \frac{1}{1 + \exp\left(-\frac{x - q_{0.1}}{\mathrm{IQR}}\right)}
}
where \eqn{q_{0.1}} is the 10th percentile of brightness values
(\eqn{x = R + G + B}), and \eqn{IQR} is their interquartile range.

This weighting suppresses gradients in poorly exposed regions to reduce
spurious values caused by low signal-to-noise ratios.
}
\note{
This function is part of a paper under preparation.
}
\examples{
\dontrun{
caim <- read_caim()
com <- complementary_gradients(caim)
plot(com)
}
}
\references{
\insertAllCited{}
}
