% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbwPoint.R
\name{rbwPoint}
\alias{rbwPoint}
\title{Residual Balancing Weights for Estimating the Average Treatment Effect (ATE) in a Point Treatment Setting}
\usage{
rbwPoint(
  treatment,
  data,
  baseline_x,
  base_weights,
  max_iter = 200,
  tol = 1e-04,
  print_level = 1
)
}
\arguments{
\item{treatment}{A symbol or character string for the treatment variable in \code{data}.}

\item{data}{A data frame containing all variables in the model.}

\item{baseline_x}{An expression for a set of baseline confounders stored in \code{data} or a character
vector of the names of these variables.}

\item{base_weights}{(Optional) A vector of base weights (or its name).}

\item{max_iter}{Maximum number of iterations for Newton's method in entropy minimization.}

\item{tol}{Tolerance parameter used to determine convergence in entropy minimization.
See documentation for \code{\link{eb2}}.}

\item{print_level}{The level of printing. See documentation for \code{\link{eb2}}.}
}
\value{
A list containing the results.
 \item{weights}{A vector of residual balancing weights.}
 \item{constraints}{A matrix of (linearly independent) residual balancing constraints}
 \item{eb_out}{Results from calling the \code{\link{eb2}} function}
 \item{call}{The matched call.}
}
\description{
\code{rbwPoint} is a function that produces residual balancing weights in a point treatment setting. It takes
a set of baseline confounders and computes the residuals for each confounder by centering it around
its sample mean. The weights can be used to fit marginal structural models to estimate the average treatment
effect (ATE).
}
\examples{
# residual balancing weights
rbwPoint_fit <- rbwPoint(treat, baseline_x = c(log_TotalPop, PercentOver65, log_Inc,
  PercentHispanic, PercentBlack, density,
  per_collegegrads, CanCommute), data = advertisement)

# attach residual balancing weights to data
advertisement$rbw_point <- rbwPoint_fit$weights

# fit marginal structural model
if(require(survey)){
  rbw_design <- svydesign(ids = ~ 1, weights = ~ rbw_point, data = advertisement)
  # the outcome model includes the treatment, the square of the treatment,
  # and state-level fixed effects (Fong, Hazlett, and Imai 2018)
  msm_rbwPoint <- svyglm(Cont ~ treat + I(treat^2) + factor(StFIPS), design = rbw_design)
  summary(msm_rbwPoint)
}

}
