% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_epitope}
\alias{rba_uniprot_epitope}
\title{Retrieve Epitopes by Accession}
\usage{
rba_uniprot_epitope(accession, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing the UniProt epitope features details for the given
  accession.
}
\description{
Use this function to retrieve epitope annotations linked to a UniProt entry.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/epitope/\{accession\}"
}

\examples{
\donttest{
rba_uniprot_epitope(accession = "P36222")
}

}
\seealso{
Other "UniProt - Epitopes": 
\code{\link{rba_uniprot_epitope_search}()},
\code{\link{rba_uniprot_rna_edit}()}
}
\concept{"UniProt - Epitopes"}
