% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_exporter_event}
\alias{rba_reactome_exporter_event}
\title{Exports A Reactome Event to SBGN or SBML}
\usage{
rba_reactome_exporter_event(event_id, output_format, save_to = NULL, ...)
}
\arguments{
\item{event_id}{Reactome event's database IDs (DbId) or Stable IDs (StId).}

\item{output_format}{Either "sbgn" or "sbml".}

\item{save_to}{NULL or Character:\itemize{
\item NULL: Save the file to an automatically-generated path.
\item Character string: A valid file path to save the file to.}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
NULL, According to the inputs, a SBGN or SBML file will be saved to
  disk.
}
\description{
This function will export a supplied Reactome Event (Pathway or Reaction)
  to a SBGN (Systems Biology Graphical Notation) or SBML (Systems Biology
  Markup Language)
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/exporter/event/
 \{identifier\}.sbgn"
 \cr "GET https://reactome.org/ContentService/exporter/event/
 \{identifier\}.sbml"
}

\examples{
\dontrun{
rba_reactome_exporter_event(event_id = "R-HSA-177929",
    output_format = "sbgn",
    save_to = "R-HSA-177929.sbgn")
}
\dontrun{
rba_reactome_exporter_event(event_id = "R-HSA-177929",
    output_format = "sbgn")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Format Exporter": 
\code{\link{rba_reactome_exporter_diagram}()},
\code{\link{rba_reactome_exporter_overview}()},
\code{\link{rba_reactome_exporter_reaction}()}
}
\concept{"Reactome Content Service - Format Exporter"}
