% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys-chunk.R
\name{chunk_keys}
\alias{chunk_keys}
\alias{parse_chunk_keys}
\alias{create_chunk_keys}
\alias{chunk_positions}
\alias{chunk_origins}
\alias{chunk_tag_str}
\alias{chunk_tag_int}
\title{Read and manipulate chunk keys}
\usage{
parse_chunk_keys(keys)

create_chunk_keys(x, z, dimension, tag, subtag)

chunk_positions(keys)

chunk_origins(keys)

chunk_tag_str(tags)

chunk_tag_int(tags)
}
\arguments{
\item{keys}{A character vector of database keys.}

\item{x}{Chunk x-coordinate.}

\item{z}{Chunk z-coordinate.}

\item{dimension}{Dimension.}

\item{tag}{The type of chunk data.}

\item{subtag}{The subchunk the key refers to (Only used for tag 47).}

\item{tags}{a vector}
}
\description{
Chunk keys are keys to chunk data. A chunk key has a format which indicates
the chunk it holds data for and the type of data it holds. This format is
either \code{chunk:x:z:d:t} or \code{chunk:x:z:d:t:s}, where \code{x} and \code{z} indicates the
coordinates of the chunk in chunk space, \code{d} indicates the dimension of
the chunk, and \code{t} and \code{s} indicate the tag and subtag of the chunk.

\code{parse_chunk_keys()} splits chunk keys into their individual elements and
returns a table with the results.

\code{create_chunk_keys()} returns a vector of chunk keys formed from its
arguments.

\code{chunk_positions()} returns a matrix containing the chunk coordinates of
keys.

\code{chunk_origins()} returns a matrix containing the block coordinate of the NW
corner of keys.

\code{chunk_tag_str()} and \code{chunk_tag_int()} convert between integer and character
representations of chunk tags.
}
\examples{
parse_chunk_keys("chunk:0:0:0:44")
parse_chunk_keys("chunk:0:0:0:47:1")
create_chunk_keys(0, 0, 0, 47, 1)

}
