% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalized_state.R
\name{FinalizedState}
\alias{FinalizedState}
\alias{get_finalized_state_value}
\alias{get_finalized_state_data}
\alias{put_finalized_state_value}
\alias{put_finalized_state_data}
\title{Load and store FinalizedState data}
\usage{
get_finalized_state_value(x, z, dimension, db = default_db())

get_finalized_state_data(x, z, dimension, db = default_db())

put_finalized_state_value(value, x, z, dimension, db = default_db())

put_finalized_state_data(values, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{value}{An integer}

\item{values}{A (named) vector of FinalizedState values. If \code{x} is
missing, the names of \code{values} will be taken as the keys.}
}
\value{
\code{get_finalized_state_value()} returns a FinalizedState data
value. \code{get_finalized_state_data()} returns a named vector of
FinalizedState data values.
}
\description{
FinalizedState data (tag 54) holds a number which indicates a chunk's state
of generation.
}
\details{
FinalizedState data contains the following information.\tabular{lll}{
   Value \tab Name \tab Description \cr
   0 \tab NeedsInstaticking \tab Chunk needs to be ticked \cr
   1 \tab NeedsPopulation \tab Chunk needs to be populated with mobs \cr
   2 \tab Done \tab Chunk generation is fully complete \cr
}

\itemize{
\item \code{get_finalized_state_value()} and \code{get_finalized_state_data()}
load FinalizedState data from \code{db}. \code{get_finalized_state_value()}
loads data for a single chunk, and \code{get_finalized_state_data()} loads
data for multiple chunks.
\item \code{put_finalized_state_value()} and \code{put_finalized_state_data()}
store FinalizedState data into \code{db}.
}
}
