% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-PipelineCollections.R
\name{PipelineCollections}
\alias{PipelineCollections}
\title{Connect and schedule pipelines}
\value{
A list containing
\describe{
\item{\code{id}}{the pipeline ID that can be used by \code{deps}}
\item{\code{pipeline}}{forked pipeline instance}
\item{\code{target_names}}{copy of \code{names}}
\item{\code{depend_on}}{copy of \code{deps}}
\item{\code{cue}}{copy of \code{cue}}
\item{\code{standalone}}{copy of \code{standalone}}
}
}
\description{
Experimental, subject to change in the future.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{verbose}}{whether to verbose the build}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{root_path}}{path to the directory that contains pipelines and
scheduler}

\item{\code{collection_path}}{path to the pipeline collections}

\item{\code{pipeline_ids}}{pipeline ID codes}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipelineCollection-new}{\code{PipelineCollections$new()}}
\item \href{#method-PipelineCollection-add_pipeline}{\code{PipelineCollections$add_pipeline()}}
\item \href{#method-PipelineCollection-build_pipelines}{\code{PipelineCollections$build_pipelines()}}
\item \href{#method-PipelineCollection-run}{\code{PipelineCollections$run()}}
\item \href{#method-PipelineCollection-get_scheduler}{\code{PipelineCollections$get_scheduler()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineCollection-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineCollections$new(root_path = NULL, overwrite = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{root_path}}{where to store the pipelines and intermediate results}

\item{\code{overwrite}}{whether to overwrite if \code{root_path} exists}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineCollection-add_pipeline"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineCollection-add_pipeline}{}}}
\subsection{Method \code{add_pipeline()}}{
Add pipeline into the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineCollections$add_pipeline(
  x,
  names = NULL,
  deps = NULL,
  pre_hook = NULL,
  post_hook = NULL,
  cue = c("always", "thorough", "never"),
  search_paths = pipeline_root(),
  standalone = TRUE,
  hook_envir = parent.frame()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a pipeline name (can be found via \code{\link{pipeline_list}}),
or a \code{\link{PipelineTools}}}

\item{\code{names}}{pipeline targets to execute}

\item{\code{deps}}{pipeline IDs to depend on; see 'Values' below}

\item{\code{pre_hook}}{function to run before the pipeline; the function needs
two arguments: input map (can be edit in-place), and path to a directory
that allows to store temporary files}

\item{\code{post_hook}}{function to run after the pipeline; the function needs
two arguments: pipeline object, and path to a directory
that allows to store intermediate results}

\item{\code{cue}}{whether to always run dependence}

\item{\code{search_paths}}{where to search for pipeline if \code{x} is a
character; ignored when \code{x} is a pipeline object}

\item{\code{standalone}}{whether the pipeline should be standalone, set to
\code{TRUE} if the same pipeline added multiple times should run
independently; default is true}

\item{\code{hook_envir}}{where to look for global environments if \code{pre_hook}
or \code{post_hook} contains global variables; default is the calling
environment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineCollection-build_pipelines"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineCollection-build_pipelines}{}}}
\subsection{Method \code{build_pipelines()}}{
Build pipelines and visualize
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineCollections$build_pipelines(visualize = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{visualize}}{whether to visualize the pipeline; default is true}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineCollection-run"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineCollection-run}{}}}
\subsection{Method \code{run()}}{
Run the collection of pipelines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineCollections$run(
  error = c("error", "warning", "ignore"),
  .scheduler = c("none", "future", "clustermq"),
  .type = c("callr", "smart", "vanilla"),
  .as_promise = FALSE,
  .async = FALSE,
  rebuild = NA,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{error}}{what to do when error occurs; default is \code{'error'}
throwing errors; other choices are \code{'warning'} and \code{'ignore'}}

\item{\code{.scheduler, .type, .as_promise, .async, ...}}{passed to
\code{\link{pipeline_run}}}

\item{\code{rebuild}}{whether to re-build the pipeline; default is \code{NA} (
if the pipeline has been built before, then do not rebuild)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineCollection-get_scheduler"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineCollection-get_scheduler}{}}}
\subsection{Method \code{get_scheduler()}}{
Get \code{scheduler} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineCollections$get_scheduler()}\if{html}{\out{</div>}}
}

}
}
