% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readDataFrame}
\alias{readDataFrame}
\title{Reads a DataFrame from the specified file.}
\usage{
readDataFrame(filepath)
}
\arguments{
\item{filepath}{The path to the file to read}
}
\value{
A data.frame object
}
\description{
The file to be read must be a DataFrame (.df) file. The content of the file
is returned as an R data.frame object.
}
\details{
The column types from Raven DataFrames are mapped to the
corresponding R types. More specifically, all integer types
(byte, short, int, long) are mapped to the R 'integer' type. The floating
point types (float, double) are mapped to the R 'double' type. Both string
and char types are mapped to the R 'character' type. Booleans are mapped to
the R 'logical' type. Binary columns are represented as R 'list' types
containing raw vectors.
}
\examples{
\dontrun{
# read a .df file into memory
df <- readDataFrame("/path/to/my/file.df")

# get the types for all columns
types <- sapply(df, typeof)
}

}
\seealso{
\code{\link[=deserializeDataFrame]{deserializeDataFrame()}} for deserializing vectors
of raw bytes. \cr
\code{\link[=writeDataFrame]{writeDataFrame()}} for writing DataFrame files which can be read
by this function.
}
